import { Router } from 'express';

const router = Router();

// Cotton City Plumbing Place ID (extracted from Google Maps URL)
const PLACE_ID = 'ChIJ-fG5p-d5hobRAAEKhobW-8M';

// Endpoint to fetch Google reviews
router.get('/google-reviews', async (req, res) => {
  try {
    // Use the Manus proxy for Google Maps API
    // The proxy URL is already configured in the Map component
    // We'll fetch reviews using the Google Places API
    
    const response = await fetch(
      `https://maps.googleapis.com/maps/api/place/details/json?place_id=${PLACE_ID}&fields=name,rating,user_ratings_total,reviews&key=${process.env.GOOGLE_MAPS_API_KEY || 'proxy'}`,
      {
        headers: {
          'Content-Type': 'application/json',
        },
      }
    );

    if (!response.ok) {
      throw new Error(`Google API error: ${response.statusText}`);
    }

    const data = await response.json();

    if (data.status !== 'OK') {
      throw new Error(`Google API returned status: ${data.status}`);
    }

    // Extract reviews and format them
    const reviews = data.result.reviews || [];
    const formattedReviews = reviews.slice(0, 5).map((review: any) => ({
      authorName: review.author_name,
      authorPhoto: review.profile_photo_url,
      rating: review.rating,
      text: review.text,
      relativeTime: review.relative_time_description,
      time: review.time,
    }));

    res.json({
      success: true,
      placeName: data.result.name,
      overallRating: data.result.rating,
      totalReviews: data.result.user_ratings_total,
      reviews: formattedReviews,
    });
  } catch (error) {
    console.error('Error fetching Google reviews:', error);
    res.status(500).json({
      success: false,
      error: 'Failed to fetch reviews',
      message: error instanceof Error ? error.message : 'Unknown error',
    });
  }
});

export default router;
