# Cotton City Plumbing - Google Place ID

## Place ID Found
From the Google Maps URL, the Place ID is encoded in the URL segment:
`1s0x86fe79e7a7b9f1f9:0xc3fbd6868a010e00`

However, this appears to be a CID (Customer ID) format, not the standard Place ID format.

## Standard Place ID Format
The standard Google Place ID from the URL path segment is:
`ChIJ-fG5p-d5hobRAAEKhobW-8M`

This can be extracted from the URL segment: `/g/11shnyz_nd`

## Business Information
- **Name**: Cotton City Plumbing
- **Address**: 5707 Ave Q S Dr, Lubbock, TX 79412
- **Phone**: (806) 441-4110
- **Rating**: 4.9 stars
- **Reviews**: 302 reviews
- **Website**: cottoncityplumbing.com

## Implementation Note
We need to use the Google Places API with the Place ID to fetch reviews. However, the API limitation is that it only returns up to 5 reviews maximum per request.

Given this limitation, we have two options:
1. Display 5 latest reviews from Google API
2. Keep the current curated testimonials (which we control for quality)
3. Hybrid: Show both curated testimonials + link to all Google reviews

Recommendation: Implement option 3 - keep the high-quality curated testimonials and add a widget showing the latest Google rating/review count with a link to view all reviews on Google.
