import fs from 'fs';

const baseUrl = "https://cottoncityplumbing.com";
const pages = [
  "/",
  "/about",
  "/contact",
  "/financing",
  "/gallery",
  "/recent-jobs",
  "/blog",
  "/privacy-policy",
  "/terms-of-use",
  "/services/water-heaters",
  "/services/drain-cleaning",
  "/services/emergency-plumbing",
  "/services/leak-detection",
  "/services/gas-lines",
  "/services/water-treatment",
  "/services/slab-leaks",
  "/services/sewer-repair",
  "/services/repiping",
  "/services/commercial",
  "/services/fixtures",
  "/services/appliances",
  "/services/valves",
  "/areas/wolfforth",
  "/areas/slaton",
  "/areas/shallowater",
  "/blog/signs-you-need-water-heater-repair",
  "/blog/hard-water-solutions-lubbock",
  "/blog/prevent-clogged-drains"
];

const sitemap = `<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  ${pages.map(page => `
  <url>
    <loc>${baseUrl}${page}</loc>
    <lastmod>${new Date().toISOString().split('T')[0]}</lastmod>
    <changefreq>weekly</changefreq>
    <priority>${page === '/' ? '1.0' : '0.8'}</priority>
  </url>`).join('')}
</urlset>`;

fs.writeFileSync('client/public/sitemap.xml', sitemap);
console.log('Sitemap generated successfully!');
