import ServicePageLayout from "@/components/ServicePageLayout";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Check } from "lucide-react";

export default function WaterTreatment() {
  return (
    <ServicePageLayout
      title="Advanced Water Treatment Solutions"
      subtitle="Experience Pure, Clean Water with Navien Premium Systems"
      heroImage="https://images.unsplash.com/photo-1504148455328-c376907d081c?q=80&w=2070&auto=format&fit=crop"
      introText={`Lubbock's hard water can wreak havoc on your plumbing, appliances, and skin. Cotton City Plumbing is proud to partner with Navien to bring you the most advanced water treatment solutions on the market. 

      We specialize in the complete line of Navien premium water treatment products, designed to protect your home and provide your family with the cleanest, healthiest water possible. From whole-home conditioning to under-sink purification, we have the perfect solution for your needs.`}
      benefits={[
        "Protect appliances from scale buildup",
        "Softer skin and hair",
        "Spot-free dishes and glassware",
        "Bottled-quality drinking water",
        "Eco-friendly, salt-free options",
        "Professional installation & support"
      ]}
      subServices={[]} // We will render custom product sections below instead of the default subServices list
      processSteps={[
        {
          title: "Water Analysis",
          desc: "We test your water hardness and quality to recommend the perfect system for your home."
        },
        {
          title: "System Selection",
          desc: "Choose from our premium Navien lineup based on your specific needs and budget."
        },
        {
          title: "Expert Installation",
          desc: "Our licensed technicians install your new system cleanly and efficiently."
        },
        {
          title: "Pure Water Enjoyment",
          desc: "Start enjoying cleaner, better-tasting water immediately after installation."
        }
      ]}
      faqs={[
        {
          question: "Why choose Navien water treatment?",
          answer: "Navien is a global leader in water technology, offering high-efficiency, durable, and innovative solutions that outperform standard big-box store systems."
        },
        {
          question: "What is the difference between PeakFlow and WEC series?",
          answer: "PeakFlow is a chemical-free, salt-free scale prevention system ideal for protecting tankless water heaters. The WEC series is a premium whole-home filtration and conditioning system that addresses a wider range of water quality issues."
        },
        {
          question: "Do I need a reverse osmosis system?",
          answer: "If you want the absolute purest drinking water for cooking and hydration, removing up to 99% of contaminants, a reverse osmosis system like the WUR500 is the best choice."
        }
      ]}
    >
      {/* Custom Product Showcase Section */}
      <div className="py-12 space-y-16">
        
        {/* WEC Series */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
          <div className="order-2 md:order-1">
            <h3 className="font-heading font-bold text-3xl text-primary mb-4">Navien WEC Series</h3>
            <p className="text-lg text-muted-foreground mb-6">
              The ultimate whole-home water treatment solution. The WEC600 combines powerful filtration with advanced conditioning to deliver exceptional water quality throughout your entire house.
            </p>
            <ul className="space-y-3 mb-6">
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Model: WEC600</strong></li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> Reduces chlorine and chemicals</li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> Protects plumbing from scale</li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> Smart monitoring technology</li>
            </ul>
          </div>
          <div className="order-1 md:order-2 bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center">
            <img src="/images/navien-wec600.png" alt="Navien WEC600 Water Treatment System" className="max-h-[400px] object-contain" />
          </div>
        </div>

        {/* PeakFlow Series */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
          <div className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center">
            <img src="/images/navien-peakflow-s.png" alt="Navien PeakFlow Series Scale Prevention" className="max-h-[400px] object-contain" />
          </div>
          <div>
            <h3 className="font-heading font-bold text-3xl text-primary mb-4">Navien PeakFlow Series</h3>
            <p className="text-lg text-muted-foreground mb-6">
              The eco-friendly, salt-free solution for scale prevention. PeakFlow technology transforms calcium and magnesium to prevent them from sticking to pipes and appliances—without removing healthy minerals.
            </p>
            <div className="space-y-4">
              <Card className="border-l-4 border-l-secondary">
                <CardHeader className="py-3"><CardTitle className="text-lg">PeakFlow S</CardTitle></CardHeader>
                <CardContent className="text-sm text-muted-foreground pb-3">Standard scale prevention for residential homes.</CardContent>
              </Card>
              <Card className="border-l-4 border-l-secondary">
                <CardHeader className="py-3"><CardTitle className="text-lg">PeakFlow A</CardTitle></CardHeader>
                <CardContent className="text-sm text-muted-foreground pb-3">Advanced anti-scale protection with enhanced flow rates.</CardContent>
              </Card>
              <Card className="border-l-4 border-l-secondary">
                <CardHeader className="py-3"><CardTitle className="text-lg">PeakFlow C</CardTitle></CardHeader>
                <CardContent className="text-sm text-muted-foreground pb-3">Commercial-grade performance for larger homes and businesses.</CardContent>
              </Card>
            </div>
          </div>
        </div>

        {/* WUR & WUA Series */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-12">
          {/* WUR500 */}
          <div className="flex flex-col h-full">
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center mb-6 flex-grow">
              <img src="/images/navien-wur500.png" alt="Navien WUR500 Reverse Osmosis System" className="max-h-[300px] object-contain" />
            </div>
            <h3 className="font-heading font-bold text-2xl text-primary mb-2">Navien WUR500 Series</h3>
            <p className="text-muted-foreground mb-4">
              Premium under-sink Reverse Osmosis (RO) system. Delivers bottled-quality water directly from your tap by removing up to 99% of contaminants.
            </p>
            <ul className="space-y-2 text-sm">
              <li className="flex items-center gap-2"><Check className="h-4 w-4 text-secondary" /> 5-stage filtration</li>
              <li className="flex items-center gap-2"><Check className="h-4 w-4 text-secondary" /> Smart faucet indicator</li>
            </ul>
          </div>

          {/* WUA500 */}
          <div className="flex flex-col h-full">
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center mb-6 flex-grow">
              <img src="/images/navien-wua500-correct.png" alt="Navien WUA500 Water Filtration System" className="max-h-[300px] object-contain" />
            </div>
            <h3 className="font-heading font-bold text-2xl text-primary mb-2">Navien WUA500 Series</h3>
            <p className="text-muted-foreground mb-4">
              Advanced ultra-filtration system that retains healthy minerals while removing harmful chemicals, chlorine, and sediment.
            </p>
            <ul className="space-y-2 text-sm">
              <li className="flex items-center gap-2"><Check className="h-4 w-4 text-secondary" /> No wastewater</li>
              <li className="flex items-center gap-2"><Check className="h-4 w-4 text-secondary" /> Compact design</li>
            </ul>
          </div>
        </div>

      </div>
    </ServicePageLayout>
  );
}
