import ServicePageLayout from "@/components/ServicePageLayout";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Check, Flame, Zap } from "lucide-react";

export default function WaterHeaters() {
  return (
    <ServicePageLayout
      title="Water Heater Services"
      subtitle="Expert Installation & Repair for Tank & Tankless Systems"
      heroImage="https://images.unsplash.com/photo-1585704032915-c3400ca199e7?q=80&w=2070&auto=format&fit=crop"
      introText={`Hot water is essential for your daily comfort. Whether you need a quick repair, a standard replacement, or an upgrade to high-efficiency technology, Cotton City Plumbing has you covered.

      We believe in installing only the best. That's why we feature the Rheem Professional Series for standard tank replacements and the cutting-edge Navien line for premium high-efficiency and tankless solutions.`}
      benefits={[
        "Same-day emergency replacement available",
        "Expert diagnosis of all makes and models",
        "Upfront pricing with no hidden fees",
        "Energy-efficient upgrades to lower bills",
        "Licensed & insured professional installation",
        "Industry-leading warranties"
      ]}
      subServices={[]} // Custom product showcase below
      processSteps={[
        {
          title: "Diagnosis & Assessment",
          desc: "We inspect your current unit to determine if a repair is possible or if replacement is the better investment."
        },
        {
          title: "Product Selection",
          desc: "We help you choose between our standard Rheem Pro Series or premium Navien models based on your needs."
        },
        {
          title: "Professional Installation",
          desc: "We drain and remove your old unit, then install the new one to code, including all safety upgrades."
        },
        {
          title: "Cleanup & Walkthrough",
          desc: "We haul away the old heater, clean the workspace, and show you how to operate your new system."
        }
      ]}
      faqs={[
        {
          question: "Should I switch to a tankless water heater?",
          answer: "Tankless units offer endless hot water and lower energy bills but have a higher upfront cost. If you have a large family or run out of hot water often, it's a great investment."
        },
        {
          question: "How long does a water heater last?",
          answer: "Standard tank heaters typically last 8-12 years. Tankless units can last 20+ years with proper maintenance."
        },
        {
          question: "Why is my water heater making noise?",
          answer: "Popping or rumbling sounds usually indicate sediment buildup at the bottom of the tank, which causes overheating and can lead to leaks."
        }
      ]}
    >
      {/* Custom Product Showcase Section */}
      <div className="py-12 space-y-16">
        
        {/* Standard Tank Option */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
          <div className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center">
            <img src="/images/rheem-pro-series.png" alt="Rheem Professional Classic Series Water Heater" className="max-h-[400px] object-contain" />
          </div>
          <div>
            <div className="inline-block bg-secondary/10 text-secondary font-bold px-3 py-1 rounded-full text-sm mb-4">
              Standard Tank Option
            </div>
            <h3 className="font-heading font-bold text-3xl text-primary mb-4">Rheem Professional Classic Series</h3>
            <p className="text-lg text-muted-foreground mb-6">
              The gold standard for reliable, traditional water heating. Built for durability and performance, the Rheem Pro Series outperforms big-box store models with professional-grade components.
            </p>
            <ul className="space-y-3">
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Proven Reliability:</strong> Trusted by pros for decades.</li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Gas & Electric:</strong> Available in multiple sizes and fuel types.</li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Enhanced Safety:</strong> Features the Guardian System™ air/fuel shut-off device.</li>
            </ul>
          </div>
        </div>

        {/* Premium Tank Option */}
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
          <div className="order-2 md:order-1">
            <div className="inline-block bg-primary/10 text-primary font-bold px-3 py-1 rounded-full text-sm mb-4">
              Premium Heat Pump Technology
            </div>
            <h3 className="font-heading font-bold text-3xl text-primary mb-4">Navien NWP500 Heat Pump Water Heater</h3>
            <p className="text-lg text-muted-foreground mb-6">
              Experience the most energy-efficient water heating technology available. The Navien NWP500 uses advanced heat pump technology to extract heat from the air, delivering exceptional efficiency and significant energy savings.
            </p>
            <ul className="space-y-3">
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Industry-Leading Efficiency:</strong> Up to 4.0 UEF rating - the highest available.</li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Lowest Operating Costs:</strong> Save up to 75% on water heating energy bills.</li>
              <li className="flex items-center gap-2"><Check className="h-5 w-5 text-secondary" /> <strong>Smart Technology:</strong> Wi-Fi enabled with advanced diagnostics and monitoring.</li>
            </ul>
          </div>
          <div className="order-1 md:order-2 bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center">
            <img src="/images/navien-nwp500-clean.jpg" alt="Navien NWP500 Heat Pump Water Heater" className="max-h-[400px] object-contain" />
          </div>
        </div>

        {/* Tankless Option */}
        <div className="bg-primary/5 rounded-3xl p-8 md:p-12">
          <div className="text-center max-w-3xl mx-auto mb-12">
            <div className="inline-block bg-secondary text-primary font-bold px-4 py-1 rounded-full text-sm mb-4">
              Endless Hot Water
            </div>
            <h3 className="font-heading font-bold text-3xl md:text-4xl text-primary mb-4">Navien NPE-2 Series Tankless</h3>
            <p className="text-lg text-muted-foreground">
              We are all about Navien when it comes to tankless. The NPE-2 series is the #1 selling condensing tankless water heater in North America for a reason.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
            <div className="bg-white p-8 rounded-2xl shadow-lg border border-gray-100 flex items-center justify-center">
              <img src="/images/navien-npe-240a.jpg" alt="Navien NPE-2 Tankless Water Heater" className="max-h-[400px] object-contain" />
            </div>
            <div className="space-y-6">
              <div className="flex gap-4">
                <div className="bg-white p-3 rounded-full shadow-sm h-fit">
                  <Zap className="h-6 w-6 text-secondary" />
                </div>
                <div>
                  <h4 className="font-bold text-xl text-primary">Endless Hot Water</h4>
                  <p className="text-muted-foreground">Never run out of hot water again, even with back-to-back showers.</p>
                </div>
              </div>
              <div className="flex gap-4">
                <div className="bg-white p-3 rounded-full shadow-sm h-fit">
                  <Flame className="h-6 w-6 text-secondary" />
                </div>
                <div>
                  <h4 className="font-bold text-xl text-primary">Space Saving Design</h4>
                  <p className="text-muted-foreground">Wall-mounted unit frees up valuable floor space in your garage or closet.</p>
                </div>
              </div>
              <div className="flex gap-4">
                <div className="bg-white p-3 rounded-full shadow-sm h-fit">
                  <Check className="h-6 w-6 text-secondary" />
                </div>
                <div>
                  <h4 className="font-bold text-xl text-primary">Longer Lifespan</h4>
                  <p className="text-muted-foreground">Lasts up to 2x longer than traditional tank heaters with proper maintenance.</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        {/* Product Registration Section */}
        <div className="bg-black text-white rounded-3xl p-8 md:p-12 mt-12">
          <div className="max-w-4xl mx-auto text-center space-y-6">
            <div className="inline-flex items-center gap-3 bg-primary/20 border-2 border-primary px-6 py-3 rounded-none">
              <Check className="h-6 w-6 text-primary" />
              <span className="font-heading font-bold text-xl uppercase">Product Registration</span>
            </div>
            
            <h3 className="font-heading font-bold text-3xl md:text-4xl uppercase italic">
              Protect Your <span className="text-primary">Investment</span>
            </h3>
            
            <p className="text-lg text-gray-300 max-w-2xl mx-auto">
              Register your new Rheem or Navien water heater to activate full warranty coverage and receive important product updates. We'll help you through the process!
            </p>

            <div className="grid md:grid-cols-2 gap-6 pt-6">
              <Card className="bg-white/10 border-2 border-white/20 hover:border-primary transition-colors">
                <CardHeader>
                  <CardTitle className="font-heading text-xl uppercase text-white flex items-center justify-center gap-2">
                    <img src="/images/rheem-pro-series.png" alt="Rheem" className="h-8" />
                    Rheem Registration
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <p className="text-gray-300 text-sm">
                    Register your Rheem water heater to access warranty benefits and extend coverage options.
                  </p>
                  <a 
                    href="https://www.rheem.com/warranties/" 
                    target="_blank" 
                    rel="noopener noreferrer"
                    className="inline-block w-full bg-primary hover:bg-primary/90 text-white font-bold py-3 px-6 rounded-none uppercase transition-colors"
                  >
                    Register Rheem Product →
                  </a>
                </CardContent>
              </Card>

              <Card className="bg-white/10 border-2 border-white/20 hover:border-primary transition-colors">
                <CardHeader>
                  <CardTitle className="font-heading text-xl uppercase text-white flex items-center justify-center gap-2">
                    Navien Registration
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <p className="text-gray-300 text-sm">
                    Register your Navien tankless water heater within 60 days to activate full warranty coverage.
                  </p>
                  <a 
                    href="https://www.navieninc.com/register" 
                    target="_blank" 
                    rel="noopener noreferrer"
                    className="inline-block w-full bg-primary hover:bg-primary/90 text-white font-bold py-3 px-6 rounded-none uppercase transition-colors"
                  >
                    Register Navien Product →
                  </a>
                </CardContent>
              </Card>
            </div>

            <p className="text-sm text-gray-400 pt-4">
              Need help registering? Call us at <a href="tel:8064414110" className="text-primary hover:underline font-bold">(806) 441-4110</a> and we'll walk you through it.
            </p>
          </div>
        </div>

      </div>
    </ServicePageLayout>
  );
}
