import ServicePageLayout from "@/components/ServicePageLayout";

export default function Valves() {
  return (
    <ServicePageLayout
      title="Valve Services"
      subtitle="Critical Water Control & Pressure Regulation"
      heroImage="/images/hero-truck.png"
      introText={`Valves are the unsung heroes of your plumbing system, controlling the flow and pressure of water throughout your home. A faulty valve can lead to leaks, low water pressure, or the inability to shut off water during an emergency. Cotton City Plumbing provides expert valve installation, repair, and replacement services.
      
      From main shut-off valves to pressure reducing valves (PRVs), we ensure your home's water control systems are functioning correctly. Proper valve maintenance protects your pipes and appliances from high pressure damage and gives you control when you need it most.`}
      benefits={[
        "Emergency Shut-Off Control",
        "Pressure Regulation",
        "Leak Prevention",
        "System Protection",
        "Code Compliance",
        "Durable Brass Components"
      ]}
      subServices={[
        {
          title: "Main Shut-Off Valves",
          desc: "Installation and replacement of the main water valve for your home, allowing you to turn off all water in an emergency."
        },
        {
          title: "Pressure Reducing Valves (PRV)",
          desc: "Devices that lower high municipal water pressure to safe levels, protecting your pipes and appliances."
        },
        {
          title: "Angle Stops & Supply Valves",
          desc: "Replacement of the small shut-off valves under sinks and behind toilets."
        },
        {
          title: "Backflow Preventers",
          desc: "Installation and testing of valves that prevent contaminated water from flowing back into your clean water supply."
        }
      ]}
      processSteps={[
        {
          title: "Diagnosis",
          desc: "We test your water pressure and inspect existing valves for corrosion, leaks, or seizure."
        },
        {
          title: "Recommendation",
          desc: "We recommend the appropriate valve type and placement for your specific plumbing system needs."
        },
        {
          title: "Installation",
          desc: "We cut out old, faulty valves and solder or press new, high-quality brass valves into place."
        },
        {
          title: "Verification",
          desc: "We test the new valves to ensure they hold pressure and shut off completely."
        }
      ]}
      faqs={[
        {
          question: "Why is my water pressure so high?",
          answer: "If your water pressure is consistently above 80 psi, your Pressure Reducing Valve (PRV) may have failed. High pressure can damage pipes and appliances."
        },
        {
          question: "Where is my main water shut-off valve?",
          answer: "It is usually located near the street in a meter box, or where the main water line enters your house (often in a garage, closet, or flower bed)."
        },
        {
          question: "Why won't my shut-off valve turn?",
          answer: "Old gate valves often seize up over time due to mineral deposits. We recommend replacing them with modern ball valves, which are more reliable and easier to operate."
        },
        {
          question: "Do I need a backflow preventer?",
          answer: "Backflow preventers are typically required for irrigation systems and commercial properties to protect the public water supply."
        }
      ]}
    />
  );
}
