import ServicePageLayout from "@/components/ServicePageLayout";

export default function SewerRepair() {
  return (
    <ServicePageLayout
      title="Sewer Repair"
      subtitle="Expert Sewer Line Repair & Replacement in Lubbock"
      heroImage="/images/hero-truck.png"
      introText={`Sewer line issues can be a homeowner's worst nightmare, causing messy backups, foul odors, and potential property damage. At Cotton City Plumbing, we specialize in fast, effective sewer repair services to restore your plumbing system's integrity.
      
      Our licensed plumbers use advanced diagnostic tools to pinpoint the exact cause of your sewer problems, whether it's tree root intrusion, pipe collapse, or severe blockages. We offer both traditional excavation and trenchless repair options to suit your specific needs and budget.`}
      benefits={[
        "Advanced Camera Inspections",
        "Trenchless Repair Options",
        "Tree Root Removal",
        "Licensed & Insured Plumbers",
        "Upfront Pricing",
        "Emergency Service Available"
      ]}
      subServices={[
        {
          title: "Sewer Line Repair",
          desc: "Fixing cracks, breaks, and leaks in your main sewer line to prevent sewage backups and environmental hazards."
        },
        {
          title: "Sewer Line Replacement",
          desc: "Complete replacement of old, deteriorated, or collapsed sewer lines using durable modern materials."
        },
        {
          title: "Root Intrusion Removal",
          desc: "Clearing tree roots that have infiltrated your sewer pipes and repairing the damage they caused."
        },
        {
          title: "Sewer Cleanout Installation",
          desc: "Installing accessible cleanout points to make future maintenance and blockage clearing easier."
        }
      ]}
      processSteps={[
        {
          title: "Video Inspection",
          desc: "We start by inserting a high-definition camera into your sewer line to visually inspect the pipe's condition and locate the problem."
        },
        {
          title: "Diagnosis & Options",
          desc: "Based on our findings, we explain the issue clearly and present you with repair or replacement options, including upfront pricing."
        },
        {
          title: "Professional Repair",
          desc: "Our team executes the chosen repair method efficiently, minimizing disruption to your property and ensuring a long-lasting solution."
        },
        {
          title: "Final Testing",
          desc: "After the repair is complete, we test the system to ensure proper flow and function before cleaning up the work area."
        }
      ]}
      faqs={[
        {
          question: "How do I know if I need sewer repair?",
          answer: "Common signs include multiple slow drains, foul sewage odors in your home or yard, gurgling sounds from toilets, and wet patches on your lawn."
        },
        {
          question: "Do you offer trenchless sewer repair?",
          answer: "Yes, we offer trenchless options like pipe bursting and lining when appropriate. These methods allow us to repair or replace your sewer line without digging up your entire yard."
        },
        {
          question: "How long does sewer repair take?",
          answer: "Simple repairs can often be completed in a day. Major replacements or complex issues may take 2-3 days depending on the extent of the damage and the method used."
        },
        {
          question: "Will my insurance cover sewer line repair?",
          answer: "Standard homeowners insurance typically doesn't cover wear and tear, but may cover accidental damage. You may have a separate service line endorsement. We recommend checking with your provider."
        }
      ]}
    />
  );
}
