import ServicePageLayout from "@/components/ServicePageLayout";

export default function Repiping() {
  return (
    <ServicePageLayout
      title="Whole House Repiping"
      subtitle="Modern Pipe Replacement for Older Homes in Lubbock"
      heroImage="/images/hero-truck.png"
      introText={`Is your home suffering from low water pressure, rusty water, or frequent leaks? These are often signs that your galvanized steel or copper pipes are corroding and nearing the end of their lifespan. Whole house repiping is the permanent solution to restore clean, reliable water flow to your home.
      
      Cotton City Plumbing specializes in replacing outdated plumbing systems with modern, durable PEX or copper piping. Our repiping process is designed to be as non-intrusive as possible, ensuring your home is treated with respect while we upgrade your infrastructure for decades of trouble-free performance.`}
      benefits={[
        "Improved Water Pressure",
        "Clean, Rust-Free Water",
        "Eliminate Frequent Leaks",
        "Increase Home Value",
        "25-Year Warranty on PEX",
        "Minimal Drywall Impact"
      ]}
      subServices={[
        {
          title: "PEX Repiping",
          desc: "Installation of flexible, durable cross-linked polyethylene (PEX) piping that resists scale buildup and freezing."
        },
        {
          title: "Copper Repiping",
          desc: "Replacement with high-quality copper pipes for homeowners who prefer traditional, time-tested materials."
        },
        {
          title: "Slab Leak Reroutes",
          desc: "Rerouting water lines through walls or attics to bypass leaking pipes buried under your concrete foundation."
        },
        {
          title: "Main Water Line Replacement",
          desc: "Replacing the main water service line from the meter to your home to ensure maximum flow and pressure."
        }
      ]}
      processSteps={[
        {
          title: "In-Home Assessment",
          desc: "We inspect your current plumbing system, check water pressure, and identify problem areas to provide a detailed repiping plan."
        },
        {
          title: "Preparation & Protection",
          desc: "Before starting, we cover your floors and furniture to protect your home from dust and debris during the work."
        },
        {
          title: "Pipe Installation",
          desc: "We carefully open small sections of drywall to access and replace old pipes with new PEX or copper lines."
        },
        {
          title: "Testing & Cleanup",
          desc: "The new system is pressure-tested for leaks. Once approved, we clean up the workspace. (Note: Drywall patching is typically coordinated with a specialist)."
        }
      ]}
      faqs={[
        {
          question: "How do I know if I need to repipe my house?",
          answer: "Signs include low water pressure, brown or yellow water, frequent pinhole leaks, or if your home was built before 1970 and has original galvanized pipes."
        },
        {
          question: "How long does it take to repipe a house?",
          answer: "Most whole-house repiping projects in Lubbock take between 2 to 5 days, depending on the size of the home and the number of bathrooms."
        },
        {
          question: "Will I have water during the repiping process?",
          answer: "Yes, in most cases we only shut off the water during the day while we are working. We aim to restore water service to at least one bathroom and the kitchen each evening."
        },
        {
          question: "Is PEX better than copper?",
          answer: "PEX is generally more affordable, faster to install, and more resistant to freezing and scale. Copper is more durable against rodents and UV light but is more expensive. We can help you choose the best option."
        }
      ]}
    />
  );
}
