import ServicePageLayout from "@/components/ServicePageLayout";

export default function LeakDetection() {
  return (
    <ServicePageLayout
      title="Leak Detection Services"
      subtitle="Advanced Technology to Find Hidden Leaks Fast"
      heroImage="https://images.unsplash.com/photo-1585704032915-c3400ca199e7?q=80&w=2070&auto=format&fit=crop"
      introText={`Water leaks can be elusive and destructive. A small leak behind a wall or under a slab can go unnoticed for months, causing structural damage, mold growth, and high water bills. At Cotton City Plumbing, we use state-of-the-art leak detection technology to pinpoint the exact location of leaks without unnecessary destruction.

      Our non-invasive methods allow us to find leaks in walls, ceilings, and concrete slabs with precision. Once located, we provide targeted repair solutions that minimize damage to your home and get your plumbing back to normal quickly.`}
      benefits={[
        "Non-invasive detection methods",
        "Pinpoint accuracy saves money",
        "Prevents structural damage",
        "Reduces high water bills",
        "Slab leak expertise",
        "Comprehensive repair solutions"
      ]}
      subServices={[
        {
          title: "Slab Leak Detection",
          desc: "Locating leaks buried deep within your home's concrete foundation using acoustic equipment."
        },
        {
          title: "Wall & Ceiling Leaks",
          desc: "Finding hidden pipe leaks behind drywall or in ceilings before they cause major rot or mold."
        },
        {
          title: "Yard Line Leaks",
          desc: "Detecting breaks in your main water service line running through your yard."
        },
        {
          title: "High Water Bill Investigation",
          desc: "Systematic testing to determine why your water usage has spiked unexpectedly."
        }
      ]}
      processSteps={[
        {
          title: "Initial Inspection",
          desc: "We review your water meter and pressure levels to confirm that a leak exists in the system."
        },
        {
          title: "Electronic Detection",
          desc: "Using acoustic listening devices and thermal imaging, we scan your home to locate the leak source."
        },
        {
          title: "Pinpoint Isolation",
          desc: "We mark the exact spot of the leak, minimizing the area that needs to be accessed for repair."
        },
        {
          title: "Targeted Repair",
          desc: "We present repair options, from spot repairs to rerouting pipes, to fix the issue permanently."
        }
      ]}
      faqs={[
        {
          question: "How do I know if I have a hidden leak?",
          answer: "Common signs include an unexplained increase in your water bill, the sound of running water when taps are off, damp spots on floors or walls, or a spinning water meter dial."
        },
        {
          question: "Will you have to tear up my floor?",
          answer: "Not necessarily. While slab leaks sometimes require breaking concrete, we often offer alternative solutions like rerouting the pipe through the attic or walls to avoid damaging your flooring."
        },
        {
          question: "Is leak detection covered by insurance?",
          answer: "Many homeowner's insurance policies cover the cost of 'access' to repair a leak (like breaking the slab) and the resulting water damage, but not the pipe repair itself. We can help document findings for your claim."
        },
        {
          question: "Can a small leak really cause damage?",
          answer: "Yes. Even a pinhole leak can waste thousands of gallons of water a month and erode the soil under your foundation, leading to serious structural issues over time."
        }
      ]}
    />
  );
}
