import ServicePageLayout from "@/components/ServicePageLayout";

export default function GasLines() {
  return (
    <ServicePageLayout
      title="Gas Line Services"
      subtitle="Safe Repair, Installation & Testing for Gas Systems"
      heroImage="https://images.unsplash.com/photo-1607472586893-edb57bdc0e39?q=80&w=2070&auto=format&fit=crop"
      introText={`Natural gas powers many of the essential appliances in your home, but it must be handled with extreme care. Gas leaks or improper installation can pose serious safety risks to your family and property. Cotton City Plumbing provides licensed, professional gas line services to ensure your system is safe and code-compliant.

      Whether you need a new gas line for a kitchen upgrade, a repair for a detected leak, or an annual safety inspection, our certified technicians have the training and equipment to handle the job safely. We work with both natural gas and propane systems.`}
      benefits={[
        "Licensed & certified gas fitters",
        "Safety-first approach",
        "Code-compliant installations",
        "Advanced leak detection",
        "Emergency repair service",
        "Pressure testing included"
      ]}
      subServices={[
        {
          title: "Gas Leak Repair",
          desc: "Immediate detection and repair of gas leaks to restore safety to your home."
        },
        {
          title: "New Line Installation",
          desc: "Running new gas lines for stoves, dryers, water heaters, fireplaces, or outdoor grills."
        },
        {
          title: "System Pressure Testing",
          desc: "Rigorous pressure tests to ensure your entire gas system is sealed and secure."
        },
        {
          title: "Code Upgrades",
          desc: "Updating older gas piping to meet current safety codes and regulations."
        }
      ]}
      processSteps={[
        {
          title: "Safety Check",
          desc: "We immediately shut off the gas supply if a leak is suspected to ensure the area is safe."
        },
        {
          title: "Pressure Testing",
          desc: "We use a pressure gauge to confirm the presence of a leak and isolate the affected section."
        },
        {
          title: "Precision Repair",
          desc: "We repair or replace the damaged pipe using approved materials and methods."
        },
        {
          title: "Final Verification",
          desc: "We re-test the entire system and verify that all appliances are firing correctly before leaving."
        }
      ]}
      faqs={[
        {
          question: "What should I do if I smell gas?",
          answer: "Evacuate your home immediately. Do not use light switches or phones inside. Call 911 and your gas utility provider from a safe distance, then call us for repairs."
        },
        {
          question: "Can you run a gas line for my outdoor grill?",
          answer: "Yes! We frequently install dedicated gas lines for outdoor kitchens, fire pits, and grills so you never have to worry about refilling propane tanks again."
        },
        {
          question: "Why did the city turn off my gas meter?",
          answer: "If a leak is detected, the utility company will lock your meter for safety. You must hire a licensed plumber (like us) to repair the leak and pass a city inspection before service can be restored."
        },
        {
          question: "What material do you use for gas lines?",
          answer: "We use code-approved materials such as black iron pipe or CSST (Corrugated Stainless Steel Tubing) depending on the specific application and local building codes."
        }
      ]}
    />
  );
}
