import ServicePageLayout from "@/components/ServicePageLayout";

export default function CommercialPlumbing() {
  return (
    <ServicePageLayout
      title="Commercial Plumbing"
      subtitle="Reliable Plumbing Solutions for Lubbock Businesses"
      heroImage="/images/hero-truck.png"
      introText={`Running a business is hard enough without having to worry about plumbing disasters. A clogged drain, a broken water heater, or a gas leak can shut down your operations and cost you revenue. Cotton City Plumbing provides prompt, professional commercial plumbing services to keep your business running smoothly.
      
      We serve a wide range of commercial clients in Lubbock, including restaurants, retail stores, office buildings, schools, and apartment complexes. Our team understands the unique demands of commercial systems and offers flexible scheduling to minimize disruption to your customers and employees.`}
      benefits={[
        "Priority Commercial Response",
        "Licensed & Bonded Technicians",
        "Code Compliance Experts",
        "Preventative Maintenance Plans",
        "Backflow Installation & Replacement",
        "Grease Trap Services"
      ]}
      subServices={[
        {
          title: "Commercial Drain Cleaning",
          desc: "Professional auger and mechanical cleaning services to clear stubborn blockages in commercial kitchens and restrooms."
        },
        {
          title: "Commercial Water Heaters",
          desc: "Installation and repair of high-capacity commercial water heaters and boiler systems."
        },
        {
          title: "Gas Line Services",
          desc: "Safety inspections, leak detection, and new gas line installation for commercial kitchens and heating systems."
        },
        {
          title: "Fixture Installation",
          desc: "Heavy-duty faucet, toilet, and urinal installation designed to withstand high-volume public use."
        }
      ]}
      processSteps={[
        {
          title: "Consultation",
          desc: "We discuss your specific business needs and plumbing issues to understand the scope and urgency of the work."
        },
        {
          title: "Site Inspection",
          desc: "Our technicians evaluate your commercial plumbing system to identify the root cause of problems or assess installation requirements."
        },
        {
          title: "Proposal & Scheduling",
          desc: "We provide a clear, written estimate and schedule the work at a time that minimizes impact on your business operations."
        },
        {
          title: "Execution & Compliance",
          desc: "We complete the work to code, ensuring all safety standards are met, and provide documentation for your records."
        }
      ]}
      faqs={[
        {
          question: "Do you offer emergency commercial plumbing services?",
          answer: "Yes, we understand that plumbing emergencies don't stick to business hours. We offer emergency services to get your business back up and running as quickly as possible."
        },
        {
          question: "Can you handle grease trap maintenance?",
          answer: "Absolutely. We provide grease trap cleaning and maintenance services for restaurants and food service establishments to prevent backups and ensure compliance."
        },
        {
          question: "Do you perform backflow testing?",
          answer: "Yes, our certified backflow testers can perform annual inspections and repairs to ensure your business meets local water safety regulations."
        },
        {
          question: "What types of businesses do you serve?",
          answer: "We serve all types of commercial properties in Lubbock, including restaurants, hotels, retail centers, medical facilities, schools, and office complexes."
        }
      ]}
    />
  );
}
