import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowLeft, Phone, Calendar } from "lucide-react";
import SocialShareButtons from "@/components/SocialShareButtons";

export default function WaterHeaterRepairBlog() {
  return (
    <Layout>
      <SEO
        title="5 Signs You Need Water Heater Repair Immediately | Cotton City Plumbing"
        description="Is your water heater making strange noises or failing to provide hot water? Learn the top 5 warning signs that indicate you need professional repair before it's too late."
        canonical="/blog/signs-you-need-water-heater-repair"
      />

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white py-16">
        <div className="container">
          <Link href="/blog">
            <Button variant="ghost" className="text-white hover:bg-white/10 mb-6">
              <ArrowLeft className="mr-2 h-4 w-4" />
              Back to Blog
            </Button>
          </Link>
          
          <div className="max-w-4xl">
            <div className="flex items-center gap-4 text-sm mb-4 text-white/80">
              <span className="flex items-center gap-2">
                <Calendar className="h-4 w-4" />
                January 2025
              </span>
              <span>•</span>
              <span>8 min read</span>
            </div>
            
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              5 Signs You Need Water Heater Repair Immediately
            </h1>
            
            <p className="text-xl text-white/90 leading-relaxed">
              Is your water heater making strange noises or failing to provide hot water? Learn the top 5 warning signs that indicate you need professional repair before it's too late.
            </p>
          </div>
        </div>
      </section>

      {/* Article Content */}
      <article className="py-16 bg-white">
        <div className="container max-w-4xl">
          
          {/* Introduction */}
          <div className="prose prose-lg max-w-none mb-12">
            <p className="text-xl leading-relaxed text-gray-700">
              Your water heater is one of the most hardworking appliances in your home, but it's easy to take for granted until something goes wrong. Ignoring early warning signs can lead to cold showers, water damage, or even a burst tank. Here are the top 5 signs that you need to call Cotton City Plumbing for water heater repair immediately.
            </p>
          </div>

          {/* Main Content Sections */}
          <div className="space-y-12">
            
            {/* Sign 1 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">1. Strange Noises</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    If you hear popping, banging, or rumbling sounds coming from your water heater, it's likely due to sediment buildup at the bottom of the tank. As the sediment is heated, it hardens and bangs against the tank walls. This not only reduces efficiency but can also cause the tank to crack.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>What to do:</strong> Call Cotton City Plumbing for a professional tank flush and inspection. Regular maintenance can prevent this issue and extend your water heater's lifespan.
                  </p>
                </CardContent>
              </Card>
            </section>

            {/* Sign 2 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">2. Rusty or Discolored Water</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    If your hot water comes out brown, rusty, or with a metallic smell, it could indicate that the inside of your tank is rusting. If left unchecked, the rust will eat through the steel tank, leading to a major leak.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>Note:</strong> If both hot and cold water are rusty, the issue might be with your pipes instead. Our technicians can diagnose the exact source of the problem.
                  </p>
                </CardContent>
              </Card>
            </section>

            {/* Sign 3 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">3. Lack of Hot Water</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    This is the most obvious sign. If your water never gets hot enough, or if you run out of hot water much faster than usual, a heating element or the thermostat may have failed. In gas units, it could be a pilot light or burner issue.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>Common causes in Lubbock:</strong> Hard water sediment buildup, failed heating elements, or thermostat malfunction. Our team can quickly diagnose and repair the issue.
                  </p>
                </CardContent>
              </Card>
            </section>

            {/* Sign 4 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">4. Leaking Around the Tank</h2>
              
              <Card className="mb-6 bg-white border-2 border-red-200">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    Puddles of water around the base of your water heater are a serious red flag. While it could be a loose connection or a faulty relief valve, it often indicates a crack in the tank itself.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700 font-semibold text-red-900">
                    <strong>Important:</strong> A leaking tank cannot be repaired and must be replaced immediately to prevent flooding. Call us for emergency service at (806) 441-4110.
                  </p>
                </CardContent>
              </Card>
            </section>

            {/* Sign 5 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">5. Age of the Unit</h2>
              
              <Card className="mb-6 bg-white">
                <CardContent className="p-6">
                  <p className="text-lg leading-relaxed text-gray-700 mb-4">
                    Most traditional tank water heaters last between 8 to 12 years. If your unit is nearing the end of its lifespan and starts acting up, it's often more cost-effective to replace it with a new, energy-efficient model rather than paying for repeated repairs.
                  </p>
                  <p className="text-lg leading-relaxed text-gray-700">
                    <strong>Lubbock's hard water:</strong> Our mineral-rich water can shorten water heater lifespan. Regular maintenance and water treatment can help extend the life of your unit.
                  </p>
                </CardContent>
              </Card>
            </section>

          </div>

          {/* Social Share */}
          <div className="mt-16 pt-8 border-t">
            <SocialShareButtons 
              url={`${window.location.origin}/blog/signs-you-need-water-heater-repair`}
              title="5 Signs You Need Water Heater Repair Immediately"
            />
          </div>

          {/* CTA Section */}
          <Card className="mt-12 bg-gradient-to-br from-primary to-primary/90 text-white border-none">
            <CardContent className="p-8 md:p-12 text-center">
              <h2 className="font-heading font-bold text-3xl md:text-4xl mb-4">
                Don't Wait for a Cold Shower!
              </h2>
              <p className="text-xl mb-8 text-white/90">
                If you notice any of these signs, contact Cotton City Plumbing today. Our expert technicians can diagnose the issue and recommend the best solution for your home.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button size="lg" variant="secondary" className="text-lg">
                  <Phone className="mr-2 h-5 w-5" />
                  Call (806) 441-4110
                </Button>
                <Button size="lg" variant="outline" className="text-lg bg-white text-primary hover:bg-white/90">
                  Book Online
                </Button>
              </div>
            </CardContent>
          </Card>

        </div>
      </article>
    </Layout>
  );
}
