import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowLeft, Phone, Calendar, AlertTriangle } from "lucide-react";
import SocialShareButtons from "@/components/SocialShareButtons";

export default function EmergencyPlumbingSignsBlog() {
  return (
    <Layout>
      <SEO
        title="5 Signs You Need Emergency Plumbing in Lubbock | Cotton City Plumbing"
        description="Learn the critical warning signs that require immediate plumbing attention in Lubbock. From burst pipes to sewage backups, know when to call for emergency service."
        canonical="/blog/emergency-plumbing-signs"
      />

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white py-16">
        <div className="container">
          <Link href="/blog">
            <Button variant="ghost" className="text-white hover:bg-white/10 mb-6">
              <ArrowLeft className="mr-2 h-4 w-4" />
              Back to Blog
            </Button>
          </Link>
          
          <div className="max-w-4xl">
            <div className="flex items-center gap-4 text-sm mb-4 text-white/80">
              <span className="flex items-center gap-2">
                <Calendar className="h-4 w-4" />
                December 2025
              </span>
              <span>•</span>
              <span>10 min read</span>
            </div>
            
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              5 Signs You Need Emergency Plumbing in Lubbock
            </h1>
            
            <p className="text-xl text-white/90 leading-relaxed">
              Some plumbing problems can wait until Monday. Others demand immediate attention. Learn the critical warning signs that require emergency plumbing service to prevent catastrophic damage to your Lubbock home.
            </p>
          </div>
        </div>
      </section>

      {/* Article Content */}
      <article className="py-16 bg-white">
        <div className="container max-w-4xl">
          
          {/* Introduction */}
          <div className="prose prose-lg max-w-none mb-12">
            <p className="text-xl leading-relaxed text-gray-700">
              At 2 AM on a freezing Lubbock night, you hear water running somewhere in your house. Or you flush the toilet and sewage backs up into your shower. Or you smell gas near your water heater. These aren't situations where you bookmark a plumber's number for Monday morning—these are plumbing emergencies that demand immediate professional attention.
            </p>
            <p className="text-lg leading-relaxed text-gray-700">
              As Lubbock's trusted emergency plumbing service, Cotton City Plumbing has responded to thousands of after-hours calls. We've seen the difference between homeowners who called immediately and those who waited—and the waiting almost always costs more in damage, stress, and repair bills. This guide will help you recognize true plumbing emergencies so you know exactly when to pick up the phone and call for help.
            </p>
          </div>

          {/* Emergency Warning Card */}
          <Card className="mb-12 border-2 border-red-500 bg-red-50">
            <CardContent className="p-8">
              <div className="flex items-start gap-4">
                <AlertTriangle className="h-8 w-8 text-red-600 flex-shrink-0 mt-1" />
                <div>
                  <h3 className="font-heading font-bold text-2xl mb-3 text-red-900">When in Doubt, Call Us</h3>
                  <p className="text-lg text-gray-800">
                    If you're reading this article in the middle of a potential emergency, stop and call us now at <strong>(806) 441-4110</strong>. We offer 24/7 emergency service because plumbing disasters don't wait for business hours. It's always better to have a professional assess the situation than to risk catastrophic damage by waiting.
                  </p>
                </div>
              </div>
            </CardContent>
          </Card>

          {/* Main Content Sections */}
          <div className="space-y-12">
            
            {/* Sign 1 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">1. Burst or Severely Leaking Pipes</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>The Situation:</strong> Water is actively spraying, gushing, or flooding from a pipe, fixture, or appliance. This isn't a slow drip under the sink—this is water pouring into your home at a rate that could fill a bathtub in minutes.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Why It's an Emergency:</strong> A single burst pipe can discharge hundreds of gallons of water per hour, causing devastating damage to floors, walls, ceilings, furniture, and electrical systems. In Lubbock's hard water environment, older galvanized pipes are particularly vulnerable to corrosion and sudden failure. Water damage compounds exponentially with time—what starts as wet carpet can quickly become ruined subflooring, mold growth, and structural damage.
              </p>

              <Card className="bg-yellow-50 border-yellow-200">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-gray-900">Immediate Actions:</h4>
                  <ol className="space-y-2 text-primary list-decimal list-inside">
                    <li><strong>Shut off the main water valve</strong> immediately (usually located near the water meter or where the main line enters your home)</li>
                    <li><strong>Turn off electricity</strong> to affected areas if water is near outlets, appliances, or your electrical panel</li>
                    <li><strong>Move valuables and furniture</strong> away from the water if safe to do so</li>
                    <li><strong>Call Cotton City Plumbing</strong> at (806) 441-4110 for emergency service</li>
                    <li><strong>Document the damage</strong> with photos for insurance purposes</li>
                  </ol>
                </CardContent>
              </Card>

              <p className="text-lg leading-relaxed text-gray-700 mt-6">
                <strong>Common Causes in Lubbock:</strong> Frozen pipes that burst when temperatures drop (especially in attics, crawl spaces, and exterior walls), corroded galvanized pipes in older homes, water hammer from high pressure, and failed washing machine hoses.
              </p>
            </section>

            {/* Sign 2 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">2. Sewage Backup or Multiple Drain Clogs</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>The Situation:</strong> Raw sewage is backing up into your toilets, showers, or floor drains. Or multiple drains throughout your home are clogged simultaneously—when you flush the toilet, sewage bubbles up in the shower; when you run the washing machine, the kitchen sink overflows.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Why It's an Emergency:</strong> Sewage contains dangerous bacteria, viruses, and pathogens that pose serious health risks to your family and pets. Exposure can cause severe illness. Additionally, sewage backup indicates a main sewer line blockage or failure, which will only worsen and can cause extensive contamination throughout your home. In Lubbock's clay soil, tree roots frequently invade sewer lines, creating blockages that can cause sudden, catastrophic backups.
              </p>

              <Card className="bg-red-50 border-red-200">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-red-900">Health Warning:</h4>
                  <p className="text-gray-800">
                    <strong>Do not attempt to clean up sewage yourself.</strong> Raw sewage requires professional remediation with proper protective equipment and disinfection protocols. Keep children and pets away from affected areas. Avoid contact with contaminated surfaces, and wash hands thoroughly if any contact occurs.
                  </p>
                </CardContent>
              </Card>

              <p className="text-lg leading-relaxed text-gray-700 mt-6">
                <strong>Immediate Actions:</strong> Stop using all water in your home (toilets, sinks, showers, washing machine, dishwasher). Do not attempt to snake the drain yourself—you could damage pipes or worsen the blockage. Call for emergency plumbing service immediately. If sewage has entered living spaces, evacuate the area and contact your insurance company.
              </p>
            </section>

            {/* Sign 3 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">3. No Water Throughout the House</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>The Situation:</strong> You turn on faucets throughout your home and nothing comes out—no water at all, or only a weak trickle. You've confirmed that your neighbors have water and your water bill is paid.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Why It's an Emergency:</strong> Complete water loss indicates a serious problem with your main water line—either a break, severe blockage, or frozen section. Without water, you can't flush toilets, wash hands, cook, or maintain basic sanitation. If the cause is a frozen pipe, the situation is time-critical: frozen pipes can burst as they thaw, causing massive flooding. In Lubbock's winter cold snaps, we see dozens of frozen pipe emergencies when temperatures drop below 20°F.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Immediate Actions:</strong> Check if neighbors have water to rule out a municipal issue. If it's isolated to your home, call for emergency service immediately. If you suspect frozen pipes, do not attempt to thaw them with open flames or high heat—this can cause pipes to burst or start fires. Leave cabinet doors open under sinks to allow warm air circulation, but let professionals handle the thawing process.
              </p>

              <p className="text-lg leading-relaxed text-gray-700">
                <strong>Prevention Tip:</strong> During Lubbock's winter freezes, let faucets drip slightly overnight, keep cabinet doors open, and maintain heat above 55°F even when away. Insulate exposed pipes in attics, crawl spaces, and exterior walls.
              </p>
            </section>

            {/* Sign 4 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">4. Gas Smell Near Water Heater or Gas Lines</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>The Situation:</strong> You smell natural gas (a distinctive "rotten egg" odor added for safety) near your water heater, gas lines, or anywhere in your home. Or you hear a hissing sound near gas appliances.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Why It's an Emergency:</strong> Natural gas leaks are life-threatening. Gas is highly explosive—a single spark from a light switch, appliance, or even static electricity can trigger a catastrophic explosion. Gas leaks also cause carbon monoxide poisoning, which can be fatal. This is not a situation to investigate yourself or wait until morning. This is a call-911-and-evacuate-immediately emergency.
              </p>

              <Card className="bg-red-100 border-red-300 border-2">
                <CardContent className="p-6">
                  <h4 className="font-bold text-xl mb-3 text-red-900">CRITICAL SAFETY PROTOCOL:</h4>
                  <ol className="space-y-2 text-gray-900 list-decimal list-inside font-semibold">
                    <li>Evacuate everyone from the home immediately</li>
                    <li>Do NOT turn lights on or off, use phones inside, or create any sparks</li>
                    <li>Do NOT attempt to locate the leak or shut off gas valves</li>
                    <li>Once outside and at a safe distance, call 911 and Atmos Energy (Lubbock's gas provider)</li>
                    <li>Call Cotton City Plumbing only AFTER the gas company has cleared the home</li>
                  </ol>
                </CardContent>
              </Card>

              <p className="text-lg leading-relaxed text-gray-700 mt-6">
                <strong>After the Emergency:</strong> Once the gas company has secured the leak and cleared your home for re-entry, call Cotton City Plumbing to repair the gas line or water heater issue. We're licensed for gas line work and can ensure your system is safe before restoring service.
              </p>
            </section>

            {/* Sign 5 */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">5. Water Heater Failure with Active Leaking</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>The Situation:</strong> Your water heater is actively leaking water—not condensation or a few drops, but steady water pooling around the base or streaming from the tank or connections. You may also hear loud banging, popping, or hissing sounds.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Why It's an Emergency:</strong> A leaking water heater can discharge 40-80 gallons of water into your home, causing significant flood damage to floors, walls, and belongings. Worse, if the temperature and pressure relief valve has failed, the tank could rupture catastrophically, releasing scalding water and potentially causing an explosion. Strange noises often indicate sediment buildup (common in Lubbock's hard water) causing the tank to overheat and weaken.
              </p>

              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                <strong>Immediate Actions:</strong> Turn off the water supply to the water heater (look for a valve on the cold water pipe entering the top of the tank). For gas water heaters, turn the gas control valve to "OFF" or "PILOT." For electric water heaters, shut off power at the circuit breaker. Place towels or a wet-dry vacuum around the leak to minimize damage. Call for emergency service—a leaking tank cannot be repaired and must be replaced.
              </p>

              <p className="text-lg leading-relaxed text-gray-700">
                <strong>Lubbock-Specific Concern:</strong> Lubbock's hard water accelerates sediment buildup in tank water heaters, reducing their lifespan and increasing the risk of sudden failure. Regular maintenance (annual flushing and anode rod inspection) can prevent many emergency failures.
              </p>
            </section>

            {/* What's NOT an Emergency */}
            <section>
              <h2 className="font-heading font-bold text-3xl mb-6 text-primary">What's NOT a Plumbing Emergency?</h2>
              
              <p className="text-lg leading-relaxed text-gray-700 mb-4">
                While these situations require prompt attention, they can typically wait for regular business hours:
              </p>

              <ul className="space-y-3 text-lg text-gray-700 mb-6">
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Slow drains</strong> in a single fixture (unless multiple drains are affected)</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Dripping faucets</strong> (annoying but not destructive)</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Running toilets</strong> (wasteful but not immediately damaging)</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Low water pressure</strong> in one fixture</span>
                </li>
                <li className="flex items-start gap-3">
                  <span className="text-primary font-bold mt-1">•</span>
                  <span><strong>Water heater not producing hot water</strong> (if there's no leaking or gas smell)</span>
                </li>
              </ul>

              <p className="text-lg leading-relaxed text-gray-700">
                That said, if any of these issues worsen or you're unsure, it's always better to call and ask. We'd rather assess a non-emergency than have you wait and discover it was critical.
              </p>
            </section>

          </div>

          {/* Social Share Buttons */}
          <div className="mt-16 p-8 bg-gray-50 rounded-xl">
            <SocialShareButtons
              url="/blog/emergency-plumbing-signs"
              title="5 Signs You Need Emergency Plumbing in Lubbock"
              description="Learn the critical warning signs that require immediate plumbing attention. From burst pipes to sewage backups, know when to call for emergency service."
            />
          </div>

          {/* CTA Section */}
          <Card className="mt-12 bg-gradient-to-br from-primary to-primary/90 text-white border-none">
            <CardContent className="p-8 md:p-12 text-center">
              <h2 className="font-heading font-bold text-3xl md:text-4xl mb-4">
                Facing a Plumbing Emergency?
              </h2>
              <p className="text-xl mb-8 text-white/90 max-w-2xl mx-auto">
                Cotton City Plumbing offers 24/7 emergency service to Lubbock and the South Plains. Our licensed plumbers are ready to respond immediately to protect your home and family.
              </p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <Button
                  size="lg"
                  variant="secondary"
                  className="font-bold text-lg"
                  onClick={() => window.location.href = 'tel:8064414110'}
                >
                  <Phone className="mr-2 h-5 w-5" />
                  Call (806) 441-4110 Now
                </Button>
              </div>
              <p className="text-sm mt-6 text-white/80">
                Available 24/7/365 | Licensed & Insured M-44446 | Same-Day Emergency Service
              </p>
            </CardContent>
          </Card>

        </div>
      </article>
    </Layout>
  );
}
