import { Helmet } from "react-helmet-async";
import Layout from "../components/Layout";
import { Phone, MapPin, Clock, Wrench, Droplet, Flame, Home } from "lucide-react";
import { Card, CardContent } from "../components/ui/card";

export default function Woodrow() {
  return (
    <Layout>
      <Helmet>
        <title>Woodrow TX Plumber | Local Plumbing Service | Cotton City Plumbing</title>
        <meta name="description" content="Trusted plumber serving Woodrow, Texas and southern Lubbock County. Local, reliable plumbing services for rural properties and residential homes. Same-day emergency service." />
        <meta name="keywords" content="Woodrow TX plumber, plumber near Woodrow Texas, southern Lubbock County plumber, Woodrow Estates plumber, rural plumbing service" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "@id": "https://cottoncityplumbing.com/areas/woodrow",
            "name": "Cotton City Plumbing - Woodrow Service Area",
            "image": "https://cottoncityplumbing.com/images/van.jpg",
            "telephone": "+18064414110",
            "email": "services@cottoncityplumbing.com",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "1306 146th Street",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.4619721,
              "longitude": -101.8497587
            },
            "url": "https://cottoncityplumbing.com/areas/woodrow",
            "priceRange": "$$",
            "openingHoursSpecification": [
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
                "opens": "07:00",
                "closes": "19:00"
              },
              {
                "@type": "OpeningHoursSpecification",
                "dayOfWeek": "Saturday",
                "opens": "08:00",
                "closes": "12:00"
              }
            ],
            "areaServed": [
              {
                "@type": "Place",
                "name": "Woodrow",
                "containedInPlace": {
                  "@type": "AdministrativeArea",
                  "name": "Lubbock County",
                  "@id": "https://en.wikipedia.org/wiki/Lubbock_County,_Texas"
                }
              }
            ],
            "hasOfferCatalog": {
              "@type": "OfferCatalog",
              "name": "Plumbing Services",
              "itemListElement": [
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Emergency Plumbing"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Water Heater Installation"
                  }
                },
                {
                  "@type": "Offer",
                  "itemOffered": {
                    "@type": "Service",
                    "name": "Well & Septic Services"
                  }
                }
              ]
            }
          })}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="bg-gradient-to-br from-black via-gray-900 to-black text-white py-20 relative overflow-hidden">
        <div className="absolute inset-0 opacity-10">
          <div className="absolute inset-0 bg-[url('/images/texture.png')] bg-repeat"></div>
        </div>
        
        <div className="container relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h1 className="font-heading font-bold text-4xl md:text-5xl lg:text-6xl mb-6">
              Your Local <span className="text-secondary">Woodrow</span> Plumber
            </h1>
            <p className="text-xl md:text-2xl text-gray-300 mb-8">
              Serving Woodrow and southern Lubbock County with honest, reliable plumbing services for over a decade
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE
              </button>
            </div>
          </div>
        </div>
      </section>

      {/* Why Choose Us for Woodrow */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              Why Woodrow Residents Choose Cotton City Plumbing
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Located nearby in southeast Lubbock, we're your trusted local plumbing experts
            </p>

            <div className="grid md:grid-cols-2 gap-8">
              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <MapPin className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Serving Your Rural Community</h3>
                      <p className="text-muted-foreground">
                        We understand the unique plumbing needs of Woodrow properties—from spacious rural estates to Lubbock-Cooper ISD homes. Fast response from our nearby location.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Clock className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Same-Day Emergency Service</h3>
                      <p className="text-muted-foreground">
                        Plumbing emergencies don't wait for convenient times. We offer same-day service during business hours for Woodrow residents.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Home className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Rural Property Expertise</h3>
                      <p className="text-muted-foreground">
                        From well systems to septic services, we have extensive experience with the plumbing needs of Woodrow's rural properties and country estates.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>

              <Card className="border-l-4 border-l-secondary">
                <CardContent className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="bg-secondary/10 p-3 rounded-full text-secondary flex-shrink-0">
                      <Wrench className="h-6 w-6" />
                    </div>
                    <div>
                      <h3 className="font-bold text-xl mb-2">Faith-Based Values</h3>
                      <p className="text-muted-foreground">
                        As a Christian, family-owned business, we serve Woodrow families with honesty, integrity, and respect in every job we complete.
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Services for Woodrow */}
      <section className="py-16">
        <div className="container">
          <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
            Plumbing Services for Woodrow Properties
          </h2>
          <p className="text-center text-muted-foreground mb-12 text-lg max-w-3xl mx-auto">
            From rural estates to residential homes, we handle all your plumbing needs
          </p>

          <div className="grid md:grid-cols-3 gap-8 max-w-5xl mx-auto">
            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Droplet className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Emergency Plumbing</h3>
                <p className="text-muted-foreground mb-4">
                  Burst pipes, water line breaks, and severe leaks. Fast emergency response for Woodrow properties.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Flame className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Water Heaters</h3>
                <p className="text-muted-foreground mb-4">
                  Tank and tankless water heater installation and repair. Expert service for all brands and models.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>

            <Card className="hover:shadow-xl transition-shadow">
              <CardContent className="p-6 text-center">
                <div className="bg-secondary/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Wrench className="h-8 w-8 text-secondary" />
                </div>
                <h3 className="font-bold text-xl mb-3">Well & Septic Services</h3>
                <p className="text-muted-foreground mb-4">
                  Well pump repair, septic system maintenance, and rural plumbing solutions for Woodrow properties.
                </p>
                <a href="/services" className="text-secondary font-semibold hover:underline">
                  Learn More →
                </a>
              </CardContent>
            </Card>
          </div>

          <div className="text-center mt-12">
            <a
              href="/services"
              className="inline-block bg-primary hover:bg-primary/90 text-white font-bold text-lg px-8 py-4 rounded-lg shadow-lg transition-all"
            >
              View All Services
            </a>
          </div>
        </div>
      </section>

      {/* Woodrow Communities */}
      <section className="py-16 bg-muted/30">
        <div className="container">
          <div className="max-w-4xl mx-auto">
            <h2 className="font-heading font-bold text-3xl md:text-4xl text-center mb-4">
              Woodrow Communities We Serve
            </h2>
            <p className="text-center text-muted-foreground mb-12 text-lg">
              Proudly serving all of Woodrow and southern Lubbock County
            </p>

            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Woodrow Country Estates</h3>
                <p className="text-muted-foreground text-sm">Spacious rural properties</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Woodrow Estates</h3>
                <p className="text-muted-foreground text-sm">Established community</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Woodrow East</h3>
                <p className="text-muted-foreground text-sm">Growing neighborhood</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Highway 87 Corridor</h3>
                <p className="text-muted-foreground text-sm">Rural & commercial</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Cooper ISD Area</h3>
                <p className="text-muted-foreground text-sm">Family homes</p>
              </div>
              <div className="bg-white p-6 rounded-lg shadow-md text-center">
                <h3 className="font-bold text-lg mb-2">Southern Lubbock County</h3>
                <p className="text-muted-foreground text-sm">Rural properties</p>
              </div>
            </div>

            <div className="mt-12 bg-white p-8 rounded-lg shadow-lg">
              <h3 className="font-bold text-2xl mb-6 text-center text-primary">What We Service in Woodrow</h3>
              <div className="grid md:grid-cols-2 gap-6">
                <div>
                  <h4 className="font-bold text-lg mb-3">Residential Properties</h4>
                  <ul className="space-y-2 text-muted-foreground">
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Single-family homes</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Rural estates and ranches</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Country properties with acreage</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>New construction homes</span>
                    </li>
                  </ul>
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-3">Commercial & Agricultural</h4>
                  <ul className="space-y-2 text-muted-foreground">
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Local businesses</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Agricultural facilities</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Churches and community centers</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="text-secondary mt-1">✓</span>
                      <span>Schools and public buildings</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-gradient-to-br from-primary via-primary/95 to-primary/90 text-white">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="font-heading font-bold text-3xl md:text-4xl mb-6">
              Need a Plumber in Woodrow?
            </h2>
            <p className="text-xl mb-8 text-gray-100">
              Call Cotton City Plumbing for fast, reliable service you can trust
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <a
                href="tel:8064414110"
                className="bg-secondary hover:bg-secondary/90 text-white font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1 inline-flex items-center justify-center gap-2"
              >
                <Phone className="h-6 w-6" />
                CALL (806) 441-4110
              </a>
              <button
                data-token="ae9ce9953f0f4e379d45293c0f23cbb8"
                data-orgname="Cotton-City-Plumbing"
                className="hcp-button bg-white hover:bg-gray-100 text-primary font-bold text-xl px-10 py-4 rounded-lg shadow-xl transition-all transform hover:-translate-y-1"
                onClick={() => window.HCPWidget && window.HCPWidget.openModal()}
              >
                BOOK ONLINE NOW
              </button>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
