import React from 'react';
import { Helmet } from 'react-helmet-async';

const VintageTownship: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProBookingLink = 'https://www.housecallpro.com/book/';
  const lubbockCoordinates = { latitude: 33.5779, longitude: -101.8552 };

  return (
    <div className="vintage-township-landing-page">
      <Helmet>
        <title>Vintage Township Plumbing Services | Expert Plumbers in Lubbock, TX</title>
        <meta name="description" content="Premier plumbing services in Vintage Township, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more. Local, reliable, and trusted." />
        <meta name="keywords" content="Vintage Township plumbing, Lubbock plumbers, emergency plumbing Lubbock, water heater repair Vintage Township, drain cleaning Lubbock, Vintage Township services, local plumber Lubbock" />
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "[Your Company Name]",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Street Address]",
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "[Your Postal Code]"
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": ${lubbockCoordinates.latitude},
                "longitude": ${lubbockCoordinates.longitude}
              },
              "url": "[Your Website URL]",
              "telephone": "${phoneNumber}",
              "openingHoursSpecification": [
                {
                  "@type": "OpeningHoursSpecification",
                  "dayOfWeek": [
                    "Monday",
                    "Tuesday",
                    "Wednesday",
                    "Thursday",
                    "Friday",
                    "Saturday",
                    "Sunday"
                  ],
                  "opens": "00:00",
                  "closes": "23:59"
                }
              ],
              "priceRange": "$$"
            }
          `}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Vintage Township</h1>
        <p>Welcome to Vintage Township, a vibrant and uniquely designed community in Lubbock, Texas, known for its charming architecture, walkable streets, and welcoming atmosphere. Our homes are built with porches, fostering a friendly, tight-knit community with year-round events. From summertime luaus at the pool to festive 3rd of July celebrations, Vintage Township offers a truly special living experience. We are proud to serve this beautiful neighborhood with top-tier plumbing solutions.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Vintage Township's unique infrastructure and community needs, ensuring tailored and efficient service.</p>
          </div>
          <div className="card">
            <h3>Reliable & Timely</h3>
            <p>Prompt and dependable service, respecting your time and schedule, especially for urgent plumbing issues.</p>
          </div>
          <div className="card">
            <h3>Skilled Professionals</h3>
            <p>Certified and experienced plumbers dedicated to providing high-quality workmanship and lasting solutions.</p>
          </div>
          <div className="card">
            <h3>Customer Satisfaction</h3>
            <p>Committed to exceeding expectations with transparent pricing, clear communication, and exceptional service.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Services</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, major leaks, and other urgent plumbing crises to protect your Vintage Township home.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Expert installation, repair, and maintenance for all types of water heaters, ensuring consistent hot water for your family.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Thorough and effective drain cleaning services to clear blockages and prevent future issues, keeping your plumbing system flowing smoothly.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Vintage Township</h2>
        <p>Vintage Township is more than just a neighborhood; it's a lifestyle. Located between Quaker and Utica, south of 114th Street, this 320-acre subdivision boasts beautiful and unique homes ranging from 1500 to 5000 square feet. Residents enjoy numerous parks, a community pool, a splash pad, a basketball court, and vast green spaces, many within walking distance. The neighborhood is zoned for Lubbock-Cooper schools, including Lubbock-Cooper Central Elementary and Laura Bush Middle School, offering excellent educational opportunities. With its friendly atmosphere and convenient access to amenities like South Plains Mall, Vintage Township truly embodies comfortable and connected living.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Ready for Reliable Plumbing?</h2>
        <p>Call us today for expert service in Vintage Township!</p>
        <a href={`tel:${phoneNumber}`} className="phone-button">{phoneNumber}</a>
        <a href={housecallProBookingLink} target="_blank" rel="noopener noreferrer" className="booking-button">Book Now with Housecall Pro</a>
      </section>
    </div>
  );
};

export default VintageTownship;
