import Layout from "@/components/Layout";
import SEO from "@/components/SEO";

export default function TermsOfUse() {
  return (
    <Layout>
      <SEO 
        title="Terms of Use | Cotton City Plumbing"
        description="Terms of Use for Cotton City Plumbing website. Read our policies regarding website usage, intellectual property, and service agreements."
      />
      
      <div className="bg-zinc-900 py-12">
        <div className="container mx-auto px-4">
          <h1 className="text-4xl md:text-5xl font-league-gothic text-white mb-4 uppercase tracking-wide">
            Terms of Use
          </h1>
        </div>
      </div>

      <div className="py-16 bg-white">
        <div className="container mx-auto px-4 max-w-4xl">
          <div className="prose prose-lg text-gray-600">
            <p>Last Updated: January 1, 2025</p>

            <h3>1. Acceptance of Terms</h3>
            <p>By accessing and using the Cotton City Plumbing website (the "Site"), you accept and agree to be bound by the terms and provision of this agreement.</p>

            <h3>2. Use of the Site</h3>
            <p>You agree to use the Site only for lawful purposes and in a way that does not infringe the rights of, restrict or inhibit anyone else's use and enjoyment of the Site.</p>

            <h3>3. Intellectual Property</h3>
            <p>All content included on this Site, such as text, graphics, logos, button icons, images, audio clips, digital downloads, data compilations, and software, is the property of Cotton City Plumbing or its content suppliers and protected by international copyright laws.</p>

            <h3>4. Service Availability</h3>
            <p>Cotton City Plumbing reserves the right to modify, suspend, or discontinue any aspect of the Site or our services at any time without notice.</p>

            <h3>5. Limitation of Liability</h3>
            <p>Cotton City Plumbing shall not be liable for any direct, indirect, incidental, special, consequential or exemplary damages resulting from the use or the inability to use the Site or any services obtained through the Site.</p>

            <h3>6. Governing Law</h3>
            <p>These Terms shall be governed and construed in accordance with the laws of the State of Texas, without regard to its conflict of law provisions.</p>

            <h3>7. Contact Information</h3>
            <p>If you have any questions about these Terms, please contact us at (806) 441-4110.</p>
          </div>
        </div>
      </div>
    </Layout>
  );
}
