import React from 'react';

const TechTerrace: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProBookingLink = '#'; // Placeholder for actual Housecall Pro booking link

  const schemaMarkup = {
    '@context': 'http://schema.org',
    '@type': 'LocalBusiness',
    'name': 'Plumbing Services in Tech Terrace Lubbock',
    'address': {
      '@type': 'PostalAddress',
      'addressLocality': 'Lubbock',
      'addressRegion': 'TX',
      'postalCode': '79401', // Approximate postal code for Tech Terrace
      'streetAddress': 'Tech Terrace Area'
    },
    'geo': {
      '@type': 'GeoCoordinates',
      'latitude': 33.5779,
      'longitude': -101.8552
    },
    'telephone': phoneNumber,
    'url': 'https://yourwebsite.com/tech-terrace' // Placeholder for actual URL
  };

  return (
    <div className="tech-terrace-landing-page">
      {/* Schema Markup */}
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{ __html: JSON.stringify(schemaMarkup) }}
      />

      {/* SEO Meta Tags (will be handled by a parent component or Helmet in a real app) */}
      {/* For demonstration, we'll include them as comments */}
      {/*
      <title>Tech Terrace Plumbing Services | Expert Plumbers in Lubbock, TX</title>
      <meta name="description" content="Reliable plumbing services in Tech Terrace, Lubbock, TX. Emergency plumbing, water heater repair, drain cleaning, and more. Local experts you can trust."/>
      <meta name="keywords" content="Tech Terrace plumbing, Lubbock plumbing, emergency plumber Tech Terrace, water heater repair Lubbock, drain cleaning Tech Terrace, local plumber Lubbock"/>
      */}

      {/* Hero Section */}
      <section className="hero-section" style={{ backgroundColor: '#000', color: '#fff', padding: '60px 20px', textAlign: 'center' }}>
        <h1>Expert Plumbing Services in Tech Terrace, Lubbock</h1>
        <p>Your trusted local plumbers serving the historic and vibrant Tech Terrace neighborhood with unparalleled service and expertise.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section" style={{ padding: '40px 20px', backgroundColor: '#f5f5f5', textAlign: 'center' }}>
        <h2>Why Choose Us in Tech Terrace?</h2>
        <div className="cards-container" style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap', marginTop: '30px' }}>
          <div className="card" style={{ background: '#fff', borderLeft: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 200px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Local Expertise</h3>
            <p>Deep understanding of Tech Terrace's unique plumbing needs, from historic homes to modern renovations.</p>
          </div>
          <div className="card" style={{ background: '#fff', borderLeft: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 200px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Rapid Response</h3>
            <p>Quick and efficient service to address your plumbing emergencies, minimizing disruption to your day.</p>
          </div>
          <div className="card" style={{ background: '#fff', borderLeft: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 200px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Trusted Professionals</h3>
            <p>Certified and experienced plumbers dedicated to quality workmanship and customer satisfaction.</p>
          </div>
          <div className="card" style={{ background: '#fff', borderLeft: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 200px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Community Focused</h3>
            <p>Proudly serving the Tech Terrace community, contributing to its well-being and charm.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section" style={{ padding: '40px 20px', backgroundColor: '#fff', textAlign: 'center' }}>
        <h2>Our Plumbing Services in Tech Terrace</h2>
        <div className="cards-container" style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap', marginTop: '30px' }}>
          <div className="card" style={{ background: '#f5f5f5', borderBottom: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 250px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, severe leaks, and urgent plumbing issues.</p>
          </div>
          <div className="card" style={{ background: '#f5f5f5', borderBottom: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 250px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance for all types of water heaters, ensuring hot water when you need it.</p>
          </div>
          <div className="card" style={{ background: '#f5f5f5', borderBottom: '5px solid #e74c3c', padding: '20px', margin: '10px', flex: '1 1 250px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)' }}>
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains, from minor blockages to major sewer line issues.</p>
          </div>
        </div>
      </section>

      {/* About Tech Terrace Section */}
      <section className="about-neighborhood-section" style={{ padding: '40px 20px', backgroundColor: '#000', color: '#fff', textAlign: 'center' }}>
        <h2>About Tech Terrace, Lubbock</h2>
        <p>Tech Terrace is a charming and historic neighborhood in Lubbock, Texas, known for its tree-lined streets, diverse architecture, and strong community spirit. Located just south of Texas Tech University, it's a popular area for students, faculty, and families alike.</p>
        <p>The neighborhood boasts several parks, including the popular Tech Terrace Park, offering green spaces for recreation and relaxation. It's also home to excellent schools like Roscoe Wilson Elementary, making it an ideal place for families. With its proximity to the university and vibrant local businesses, Tech Terrace offers a unique blend of academic energy and residential tranquility.</p>
        <p>Local landmarks include the historic homes that give the area its distinctive character, and its walkable streets provide easy access to local eateries and coffee shops, fostering a close-knit community feel.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section" style={{ padding: '60px 20px', backgroundColor: '#e74c3c', color: '#fff', textAlign: 'center' }}>
        <h2>Ready for Reliable Plumbing Service?</h2>
        <p>Contact us today for expert plumbing solutions in Tech Terrace!</p>
        <a href={`tel:${phoneNumber}`} style={{ display: 'inline-block', background: '#000', color: '#fff', padding: '15px 30px', margin: '10px', textDecoration: 'none', borderRadius: '5px', fontWeight: 'bold' }}>Call Now: {phoneNumber}</a>
        <a href={housecallProBookingLink} target="_blank" rel="noopener noreferrer" style={{ display: 'inline-block', background: '#fff', color: '#e74c3c', padding: '15px 30px', margin: '10px', textDecoration: 'none', borderRadius: '5px', fontWeight: 'bold' }}>Book Online with Housecall Pro</a>
      </section>
    </div>
  );
};

export default TechTerrace;
