import Layout from "@/components/Layout";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Link } from "wouter";
import { ArrowRight, Wrench, Droplets, Flame, ShieldCheck, Building2, Search } from "lucide-react";

export default function Services() {
  const services = [
    {
      title: "Emergency Plumbing",
      desc: "Same-day emergency response for burst pipes, backups, and urgent repairs.",
      icon: <ShieldCheck className="h-10 w-10 text-secondary" />,
      link: "/services/emergency-plumbing"
    },
    {
      title: "Water Heaters",
      desc: "Repair and installation of tank and tankless water heater systems.",
      icon: <Flame className="h-10 w-10 text-secondary" />,
      link: "/services/water-heaters"
    },
    {
      title: "Drain Cleaning",
      desc: "Professional unclogging and hydro-jetting for all drain types.",
      icon: <Droplets className="h-10 w-10 text-secondary" />,
      link: "/services/drain-cleaning"
    },
    {
      title: "Leak Detection",
      desc: "Advanced technology to find hidden leaks behind walls and under slabs.",
      icon: <Search className="h-10 w-10 text-secondary" />,
      link: "/services/leak-detection"
    },
    {
      title: "Gas Lines",
      desc: "Safe installation, repair, and pressure testing for gas systems.",
      icon: <Flame className="h-10 w-10 text-secondary" />,
      link: "/services/gas-lines"
    },
    {
      title: "Water Treatment",
      desc: "Water softeners and filtration systems for pure, clean water.",
      icon: <Droplets className="h-10 w-10 text-secondary" />,
      link: "/services/water-treatment"
    },
    {
      title: "Slab Leaks",
      desc: "Expert detection and repair of leaks beneath your home's foundation.",
      icon: <Search className="h-10 w-10 text-secondary" />,
      link: "/services/slab-leaks"
    },
    {
      title: "Commercial Plumbing",
      desc: "Reliable plumbing solutions for businesses and property managers.",
      icon: <Building2 className="h-10 w-10 text-secondary" />,
      link: "/services/commercial"
    }
  ];

  return (
    <Layout>
      {/* Hero Section */}
      <section className="bg-primary text-white py-20">
        <div className="container text-center">
          <h1 className="font-heading font-extrabold text-4xl md:text-6xl mb-6">Our Services</h1>
          <p className="text-xl text-primary-foreground/90 max-w-2xl mx-auto">
            Comprehensive plumbing solutions for your home and business. 
            From minor repairs to major installations, we do it all with excellence.
          </p>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-background">
        <div className="container">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {services.map((service, index) => (
              <Card key={index} className="group hover:shadow-xl transition-all duration-300 border-t-4 border-t-transparent hover:border-t-secondary">
                <CardHeader>
                  <div className="mb-4 bg-primary/5 w-fit p-4 rounded-full group-hover:bg-secondary/10 transition-colors">
                    {service.icon}
                  </div>
                  <CardTitle className="text-2xl font-bold text-primary">{service.title}</CardTitle>
                </CardHeader>
                <CardContent>
                  <CardDescription className="text-base text-muted-foreground">
                    {service.desc}
                  </CardDescription>
                </CardContent>
                <CardFooter>
                  <Link href={service.link}>
                    <Button variant="link" className="p-0 text-secondary font-bold text-lg group-hover:translate-x-2 transition-transform">
                      Learn More <ArrowRight className="ml-2 h-4 w-4" />
                    </Button>
                  </Link>
                </CardFooter>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="bg-black/90 py-20">
        <div className="container text-center">
          <h2 className="font-heading font-bold text-3xl md:text-4xl text-primary uppercase italic mb-6">
            Don't See What You Need?
          </h2>
          <p className="text-lg text-white max-w-2xl mx-auto mb-8">
            This is just a selection of our most popular services. If you have a plumbing issue not listed here, give us a call. Chances are, we can fix it!
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="tel:8064414110">
              <Button className="bg-primary hover:bg-primary/90 text-white font-bold py-6 px-8 text-lg w-full sm:w-auto uppercase rounded-none">
                Call (806) 441-4110
              </Button>
            </a>
            <Link href="/contact">
              <Button variant="outline" className="border-2 border-white text-white hover:bg-white hover:text-black font-bold py-6 px-8 text-lg w-full sm:w-auto uppercase rounded-none">
                Contact Us Online
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </Layout>
  );
}
