
import React from 'react';
import { Helmet } from 'react-helmet-async';

const RemingtonPark: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProLink = '#'; // Placeholder for Housecall Pro booking link

  const schemaMarkup = {
    '@context': 'http://schema.org',
    '@type': 'LocalBusiness',
    'name': 'Remington Park Plumbing Services',
    'address': {
      '@type': 'PostalAddress',
      'addressLocality': 'Lubbock',
      'addressRegion': 'TX',
      'postalCode': '79424', // Approximate postal code for Remington Park
      'streetAddress': 'Remington Park Neighborhood'
    },
    'geo': {
      '@type': 'GeoCoordinates',
      'latitude': 33.5779,
      'longitude': -101.8552
    },
    'url': 'https://yourcompany.com/remington-park',
    'telephone': phoneNumber,
    'openingHoursSpecification': [
      {
        '@type': 'OpeningHoursSpecification',
        'dayOfWeek': [
          'Monday',
          'Tuesday',
          'Wednesday',
          'Thursday',
          'Friday',
          'Saturday',
          'Sunday'
        ],
        'opens': '00:00',
        'closes': '23:59'
      }
    ],
    'priceRange': '$$'
  };

  return (
    <div className="remington-park-page">
      <Helmet>
        <title>Remington Park Plumbing Services in Lubbock, TX | Your Company Name</title>
        <meta name="description" content="Expert plumbing services in Remington Park, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more for your neighborhood home."/>
        <meta name="keywords" content="Remington Park plumbing, Lubbock plumbing, emergency plumbing Lubbock, water heater repair Remington Park, drain cleaning Lubbock"/>
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section" style={{ backgroundColor: '#000', color: '#fff', padding: '60px 20px', textAlign: 'center' }}>
        <h1 style={{ color: '#e74c3c', fontSize: '3em', marginBottom: '10px' }}>Remington Park Plumbing Experts</h1>
        <p style={{ fontSize: '1.2em', maxWidth: '800px', margin: '0 auto' }}>
          Dedicated plumbing services for the Remington Park neighborhood in Lubbock, Texas. 
          We understand the unique needs of homes in this peaceful, family-friendly community, 
          known for its well-maintained properties and convenient location near schools like Whiteside Elementary.
        </p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section" style={{ padding: '40px 20px', backgroundColor: '#f4f4f4', textAlign: 'center' }}>
        <h2 style={{ color: '#333', marginBottom: '30px' }}>Why Choose Us in Remington Park?</h2>
        <div style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap' }}>
          <div className="card" style={{ background: '#fff', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#e74c3c' }}>Local Expertise</h3>
            <p>Familiar with Remington Park's infrastructure and common plumbing issues.</p>
          </div>
          <div className="card" style={{ background: '#fff', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#e74c3c' }}>Rapid Response</h3>
            <p>Quick and efficient service to address your plumbing emergencies.</p>
          </div>
          <div className="card" style={{ background: '#fff', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#e74c3c' }}>Quality Workmanship</h3>
            <p>Certified professionals delivering lasting solutions for your home.</p>
          </div>
          <div className="card" style={{ background: '#fff', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#e74c3c' }}>Transparent Pricing</h3>
            <p>Clear, upfront pricing with no hidden fees for Remington Park residents.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section" style={{ padding: '40px 20px', backgroundColor: '#000', color: '#fff', textAlign: 'center' }}>
        <h2 style={{ color: '#e74c3c', marginBottom: '30px' }}>Our Plumbing Services in Remington Park</h2>
        <div style={{ display: 'flex', justifyContent: 'space-around', flexWrap: 'wrap' }}>
          <div className="card" style={{ background: '#333', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#fff' }}>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, major leaks, and urgent repairs.</p>
          </div>
          <div className="card" style={{ background: '#333', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#fff' }}>Water Heater Services</h3>
            <p>Installation, repair, and maintenance for all types of water heaters.</p>
          </div>
          <div className="card" style={{ background: '#333', padding: '20px', margin: '10px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', width: '280px' }}>
            <h3 style={{ color: '#fff' }}>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains, from sinks to main sewer lines.</p>
          </div>
        </div>
      </section>

      {/* About Remington Park Section */}
      <section className="about-neighborhood-section" style={{ padding: '40px 20px', backgroundColor: '#f4f4f4', textAlign: 'center' }}>
        <h2 style={{ color: '#333', marginBottom: '30px' }}>About Remington Park, Lubbock</h2>
        <p style={{ fontSize: '1.1em', maxWidth: '800px', margin: '0 auto' }}>
          Remington Park is a highly sought-after neighborhood in Lubbock, Texas, 
          renowned for its tranquil atmosphere and strong community spirit. 
          Residents enjoy well-maintained homes and lush green spaces, including the scenic Remington Park itself, 
          which features trails and a charming pond with diverse wildlife. 
          Its convenient location offers easy access to Loop 289 and is just a short drive from downtown Lubbock. 
          Families appreciate the proximity to excellent schools like Whiteside Elementary School, 
          making it an ideal place to live and raise a family.
        </p>
      </section>

      {/* CTA Section */}
      <section className="cta-section" style={{ backgroundColor: '#e74c3c', color: '#fff', padding: '50px 20px', textAlign: 'center' }}>
        <h2 style={{ fontSize: '2.5em', marginBottom: '20px' }}>Need Plumbing Service in Remington Park?</h2>
        <p style={{ fontSize: '1.5em', marginBottom: '30px' }}>Call us today for reliable and efficient service!</p>
        <a href={`tel:${phoneNumber}`} style={{ backgroundColor: '#000', color: '#fff', padding: '15px 30px', textDecoration: 'none', borderRadius: '5px', fontSize: '1.3em', marginRight: '20px' }}>
          Call {phoneNumber}
        </a>
        <a href={housecallProLink} target="_blank" rel="noopener noreferrer" style={{ backgroundColor: '#fff', color: '#e74c3c', padding: '15px 30px', textDecoration: 'none', borderRadius: '5px', fontSize: '1.3em' }}>
          Book Online with Housecall Pro
        </a>
      </section>
    </div>
  );
};

export default RemingtonPark;
