import React from 'react';

const Raintree: React.FC = () => {
  const neighborhoodName = "Raintree";
  const phoneNumber = "(806) 441-4110";
  const urlSlug = "raintree-lubbock";

  const schemaMarkup = {
    "@context": "http://schema.org",
    "@type": "LocalBusiness",
    "name": "Raintree Neighborhood Services",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "5001 82nd St",
      "addressLocality": "Lubbock",
      "addressRegion": "TX",
      "postalCode": "79424",
      "addressCountry": "US"
    },
    "geo": {
      "@type": "GeoCoordinates",
      "latitude": 33.5779,
      "longitude": -101.8552
    },
    "telephone": "+18064414110",
    "openingHoursSpecification": [
      {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday"
        ],
        "opens": "08:00",
        "closes": "17:00"
      }
    ],
    "url": `https://www.example.com/${urlSlug}`,
    "description": "Comprehensive home services for the Raintree neighborhood in Lubbock, TX, including plumbing, HVAC, and electrical."
  };

  return (
    <div className="raintree-page">
      <head>
        <title>Raintree Lubbock Homes for Sale | Premier Living in Lubbock, TX</title>
        <meta name="description" content="Discover Raintree, a premier Lubbock neighborhood offering spacious homes, excellent schools, and convenient access to local amenities. Find your dream home in Raintree today!" />
        <meta name="keywords" content="Raintree Lubbock, Raintree homes, Lubbock TX real estate, homes for sale Raintree, Lubbock neighborhoods, Raintree community, Lubbock luxury homes" />
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </head>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to {neighborhoodName}</h1>
        <p>Welcome to Raintree, an exquisite neighborhood nestled in the heart of Lubbock, Texas. Raintree offers a harmonious blend of spacious living, modern amenities, and a vibrant community spirit. Enjoy beautifully landscaped streets, top-rated schools, and easy access to Lubbock's finest dining, shopping, and entertainment. Experience the best of Lubbock living in Raintree.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Our team possesses unparalleled knowledge of the Raintree neighborhood, ensuring you find a home that perfectly fits your lifestyle.</p>
          </div>
          <div className="card">
            <h3>Personalized Service</h3>
            <p>We provide tailored guidance throughout your home buying or selling journey, making the process seamless and stress-free.</p>
          </div>
          <div className="card">
            <h3>Community Focus</h3>
            <p>We are deeply invested in the Lubbock community, connecting you with local resources and neighborhood insights.</p>
          </div>
          <div className="card">
            <h3>Proven Results</h3>
            <p>With a track record of successful transactions in Raintree, we are dedicated to achieving your real estate goals.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Services</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>Rapid response for all your urgent plumbing needs in Raintree, ensuring minimal disruption to your home.</p>
          </div>
          <div className="card">
            <h3>Water Heater Repair & Installation</h3>
            <p>Expert service for water heaters, from routine maintenance to new installations, keeping your Raintree home comfortable.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning & Hydro Jetting</h3>
            <p>Advanced drain cleaning solutions to keep your plumbing system flowing smoothly in the Raintree neighborhood.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About {neighborhoodName}</h2>
        <h3>Community Features</h3>
        <p>Raintree boasts well-maintained parks, walking trails, and community events that foster a strong sense of belonging. Residents enjoy a peaceful suburban environment with the convenience of city living.</p>
        <h3>Location Benefits</h3>
        <p>Strategically located, Raintree offers quick access to Loop 289, making commutes effortless. It's just minutes away from Texas Tech University, Covenant Health System, and popular shopping centers like Canyon West and South Plains Mall. Families appreciate the proximity to highly-rated Lubbock Independent School District schools.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Ready to Experience Raintree?</h2>
        <p>Call us today at <a href={`tel:${phoneNumber.replace(/\D/g, '')}`}>{phoneNumber}</a> or schedule your service online!</p>
        <button className="housecall-pro-button">Schedule Your Service with Housecall Pro</button>
      </section>
    </div>
  );
};

export default Raintree;
