import Layout from "@/components/Layout";
import SEO from "@/components/SEO";

export default function PrivacyPolicy() {
  return (
    <Layout>
      <SEO 
        title="Privacy Policy | Cotton City Plumbing"
        description="Privacy Policy for Cotton City Plumbing. Learn how we collect, use, and protect your personal information."
        canonical="/privacy-policy"
      />
      
      <section className="bg-primary text-white py-12">
        <div className="container">
          <h1 className="font-heading font-bold text-4xl mb-4">Privacy Policy</h1>
          <p className="text-primary-foreground/80">Last Updated: December 6, 2025</p>
        </div>
      </section>

      <section className="py-16 bg-background">
        <div className="container max-w-4xl prose prose-lg">
          <p>
            At Cotton City Plumbing, we are committed to protecting your privacy. This Privacy Policy explains how we collect, use, and safeguard your information when you visit our website or use our services.
          </p>

          <h3>1. Information We Collect</h3>
          <p>
            We may collect personal information that you voluntarily provide to us when you:
          </p>
          <ul>
            <li>Fill out a contact form</li>
            <li>Request a service quote</li>
            <li>Call our phone number</li>
            <li>Subscribe to our newsletter</li>
          </ul>
          <p>
            This information may include your name, email address, phone number, and service address.
          </p>

          <h3>2. How We Use Your Information</h3>
          <p>
            We use the information we collect to:
          </p>
          <ul>
            <li>Provide and schedule plumbing services</li>
            <li>Respond to your inquiries and requests</li>
            <li>Send you service confirmations and updates</li>
            <li>Improve our website and customer service</li>
          </ul>

          <h3>3. Information Sharing</h3>
          <p>
            We do not sell, trade, or rent your personal information to third parties. We may share your information with trusted third-party service providers who assist us in operating our website or conducting our business, so long as those parties agree to keep this information confidential.
          </p>

          <h3>4. Security</h3>
          <p>
            We implement a variety of security measures to maintain the safety of your personal information. However, no method of transmission over the Internet or electronic storage is 100% secure.
          </p>

          <h3>5. Contact Us</h3>
          <p>
            If you have any questions about this Privacy Policy, please contact us at:
          </p>
          <address className="not-italic">
            <strong>Cotton City Plumbing</strong><br />
            Lubbock, TX<br />
            Phone: (806) 441-4110
          </address>
        </div>
      </section>
    </Layout>
  );
}
