import React from 'react';
import { Helmet } from 'react-helmet-async'; // Assuming react-helmet for SEO



const Parkway: React.FC = () => {
  return (
    <div>
      <Helmet>
        <title>Parkway Neighborhood Lubbock TX - Plumbing Services | Lubbock Plumbing Services</title>
        <meta name="description" content="Expert plumbing services in Parkway, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more for your Parkway home." />
        <meta name="keywords" content="Parkway Lubbock plumbing, Parkway TX plumber, emergency plumbing Parkway, water heater repair Parkway, drain cleaning Parkway, Parkway neighborhood services" />
        <script type="application/ld+json">
          {JSON.stringify({
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "Cotton City Plumbing",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "1306 146th Street",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.4619721,
              "longitude": -101.8497587
            },
            "url": "https://cottoncityplumbing.com",
            "telephone": "+18064414110",
            "openingHours": "Mo-Fr 08:00-17:00",
            "priceRange": "$$"
          })}
        </script>
      </Helmet>
      <header className="hero-section bg-black text-white py-20">
        <div className="container mx-auto text-center">
          <h1 className="text-5xl font-bold">Welcome to Parkway, Lubbock, TX</h1>
          <p className="mt-4 text-lg">A welcoming and growing neighborhood in northeast Lubbock, known for its community spirit, tree-lined streets, and proximity to Mackenzie Park. It offers affordable housing options and is experiencing new development.</p>
        </div>
      </header>

      <section className="why-choose-us-section py-16 bg-white text-black">
        <div className="container mx-auto text-center">
          <h2 className="text-4xl font-bold mb-10">Why Choose Us</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Local Expertise</h3>
              <p>Deep understanding of Parkway's unique plumbing needs.</p>
            </div>
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Rapid Response</h3>
              <p>Quick and efficient service for Parkway residents.</p>
            </div>
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Quality Workmanship</h3>
              <p>Reliable and lasting plumbing solutions for your home.</p>
            </div>
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Community Focused</h3>
              <p>Proudly serving the Parkway neighborhood with integrity.</p>
            </div>
          </div>
        </div>
      </section>

      <section className="services-section py-16 bg-gray-100 text-black">
        <div className="container mx-auto text-center">
          <h2 className="text-4xl font-bold mb-10">Our Services in Parkway</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Emergency Plumbing</h3>
              <p>24/7 rapid response for urgent plumbing issues in Parkway.</p>
            </div>
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Water Heaters</h3>
              <p>Installation, repair, and maintenance of water heaters for Parkway homes.</p>
            </div>
            <div className="card p-6 border border-gray-300 rounded-lg shadow-lg">
              <h3 className="text-xl font-semibold mb-3">Drain Cleaning</h3>
              <p>Effective solutions for clogged drains and sewer lines in Parkway.</p>
            </div>
          </div>
        </div>
      </section>

      <section className="about-parkway-section py-16 bg-white text-black">
        <div className="container mx-auto">
          <h2 className="text-4xl font-bold mb-10 text-center">About the Parkway Neighborhood</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
              <h3 className="text-2xl font-semibold mb-4">Community Features</h3>
              <p>Parkway is a quiet, residential area with well-kept homes and friendly neighbors. Its tree-lined streets make it a walkable neighborhood. Residents enjoy proximity to Mackenzie Park, which offers equestrian trails, a disc golf course, a dog park, and the Meadowbrook Canyon Creek Golf Club. The neighborhood is also home to the TJ Patterson Branch Library and the FiberMax Center for Discovery museum.</p>
            </div>
            <div>
              <h3 className="text-2xl font-semibold mb-4">Location Benefits</h3>
              <p>Located in northeast Lubbock, Parkway is within the Loop and is experiencing moderate growth with affordable housing options and new developments. It's well-connected by major thoroughfares. Families benefit from access to Lubbock Independent School District, including Alderson Elementary, Dunbar College Preparatory Academy, and Estacado High School. The Talkington School for Young Women Leaders and Rise Academy are also nearby.</p>
            </div>
          </div>
        </div>
      </section>

      <section className="cta-section bg-red-600 text-white py-16 text-center">
        <div className="container mx-auto">
          <h2 className="text-4xl font-bold mb-6">Need Plumbing Services in Parkway?</h2>
          <p className="text-2xl mb-8">Call us today for reliable service!</p>
          <a href="tel:+18064414110" className="bg-black text-white px-8 py-4 rounded-full text-xl font-semibold hover:bg-gray-800 transition duration-300">(806) 441-4110</a>
          <button className="bg-white text-red-600 px-8 py-4 rounded-full text-xl font-semibold ml-4 hover:bg-gray-200 transition duration-300">Book Now with Housecall Pro</button>
        </div>
      </section>

    </div>
  );
};

export default Parkway;
