import React from 'react';
import { Helmet } from 'react-helmet-async';

const Northridge: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProBookingLink = 'https://www.housecallpro.com/book/your-company-name'; // Placeholder, replace with actual link

  return (
    <div className="northridge-landing-page">
      <Helmet>
        <title>Northridge Neighborhood Plumbing Services - Lubbock, TX</title>
        <meta name="description" content="Expert plumbing services in Northridge, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more for your home."/>
        <meta name="keywords" content="Northridge plumbing, Lubbock plumbers, emergency plumbing Northridge, water heater repair Lubbock, drain cleaning Northridge, Northridge TX, Lubbock Texas plumbing"/>
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "[Your Company Name] Plumbing Services - Northridge",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Company Street Address]", // Placeholder
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "79416",
                "addressCountry": "US"
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": 33.5779,
                "longitude": -101.8552
              },
              "telephone": "+18064414110",
              "url": "https://yourwebsite.com/northridge", // Placeholder
              "openingHours": "Mo-Fr 08:00-17:00", // Placeholder
              "priceRange": "$$"
            }
          `}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Expert Plumbing Services in Northridge, Lubbock, TX</h1>
        <p>Serving the quiet, family-friendly streets of Northridge with top-rated plumbing solutions. From routine maintenance to emergency repairs, we're your trusted local plumbers.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us for Your Northridge Home?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Northridge Experts</h3>
            <p>We understand the unique plumbing needs of homes in Northridge, including those built in the 80s and 90s with traditional brick exteriors.</p>
          </div>
          <div className="card">
            <h3>Fast & Reliable Service</h3>
            <p>Quick response times to keep your Northridge home comfortable and functional, minimizing disruption to your family's routine.</p>
          </div>
          <div className="card">
            <h3>Quality Workmanship</h3>
            <p>Our certified plumbers deliver lasting solutions with attention to detail, ensuring peace of mind for Northridge residents.</p>
          </div>
          <div className="card">
            <h3>Customer Satisfaction</h3>
            <p>Dedicated to exceeding expectations for every Northridge client, ensuring a smooth and professional service experience.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Northridge</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 emergency services for burst pipes, severe leaks, and other urgent plumbing issues in Northridge.</p>
          </div>
          <div className="card">
            <h3>Water Heater Repair & Installation</h3>
            <p>Expert service for all types of water heaters, ensuring your Northridge home has reliable hot water.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Thorough drain cleaning to clear blockages and prevent future issues, keeping your Northridge home's plumbing flowing smoothly.</p>
          </div>
        </div>
      </section>

      {/* About Northridge Section */}
      <section className="about-neighborhood-section">
        <h2>About Northridge, Lubbock, TX</h2>
        <p>Northridge is a desirable West Lubbock neighborhood known for its quiet, sidewalk-lined streets and family-friendly atmosphere. Residents enjoy the recently upgraded Cooke Park, featuring a new playground and picnic areas, perfect for outdoor family gatherings. The neighborhood is proudly served by the top-rated Frenship Independent School District, with North Ridge Elementary located right within the community, and Terra Vista Middle and Frenship High also highly rated. Its convenient location provides easy access to Loop 289, connecting residents to major shopping centers like West End Center, downtown Lubbock, and nearby educational institutions like Lubbock Christian University and Texas Tech. Northridge offers comfort and convenience with well-maintained traditional-style homes, making it an ideal place to live in Lubbock.</p>
        <p>Local landmarks and features include:</p>
        <ul>
          <li>**Cooke Park:** A recently upgraded park with a new playground, walking track, and picnic pavilion.</li>
          <li>**Frenship Independent School District:** A highly-rated school district serving Northridge, including North Ridge Elementary, Terra Vista Middle, and Frenship High.</li>
          <li>**West End Center:** A major shopping destination just a half-mile away, offering a variety of national brands and restaurants.</li>
          <li>**Shadow Hills Golf Course:** An 18-hole public course located just north of the neighborhood.</li>
        </ul>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Service in Northridge?</h2>
        <p>Call us today for reliable and professional plumbing solutions!</p>
        <p className="phone-number">{phoneNumber}</p>
        <a href={housecallProBookingLink} target="_blank" rel="noopener noreferrer" className="booking-button">
          Book Now with Housecall Pro
        </a>
      </section>

      {/* Styling (placeholder - integrate with existing site's CSS/SCSS) */}
      <style>{`
        .northridge-landing-page {
          font-family: Arial, sans-serif;
          color: #333;
          line-height: 1.6;
        }
        .hero-section {
          background-color: #000;
          color: #fff;
          padding: 60px 20px;
          text-align: center;
        }
        .hero-section h1 {
          color: #e30000; /* Red accent */
          margin-bottom: 15px;
        }
        .why-choose-us-section, .services-section, .about-neighborhood-section, .cta-section {
          padding: 40px 20px;
          max-width: 1200px;
          margin: 0 auto;
        }
        .why-choose-us-section h2, .services-section h2, .about-neighborhood-section h2, .cta-section h2 {
          text-align: center;
          color: #000;
          margin-bottom: 30px;
        }
        .why-choose-us-section .cards-container, .services-section .cards-container {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
          gap: 20px;
        }
        .card {
          background-color: #f9f9f9;
          border: 1px solid #ddd;
          padding: 20px;
          border-radius: 8px;
          text-align: center;
        }
        .card h3 {
          color: #e30000;
          margin-bottom: 10px;
        }
        .cta-section {
          background-color: #000;
          color: #fff;
          text-align: center;
          padding: 50px 20px;
        }
        .cta-section .phone-number {
          font-size: 2em;
          color: #e30000;
          margin: 20px 0;
        }
        .booking-button {
          display: inline-block;
          background-color: #e30000;
          color: #fff;
          padding: 15px 30px;
          text-decoration: none;
          border-radius: 5px;
          font-weight: bold;
          transition: background-color 0.3s ease;
        }
        .booking-button:hover {
          background-color: #c20000;
        }
        ul {
          list-style-type: disc;
          margin-left: 20px;
        }
        ul li {
          margin-bottom: 10px;
        }
      `}</style>
    </div>
  );
};

export default Northridge;
