import React from 'react';

const MeloniePark: React.FC = () => {
  return (
    <div className="melonie-park-landing-page">
      {/* LocalBusiness Schema Markup */}
      <script type="application/ld+json">
        {`
          {
            "@context": "http://schema.org",
            "@type": "LocalBusiness",
            "name": "Melonie Park Plumbing Services",
            "address": {
              "@type": "PostalAddress",
              "streetAddress": "",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79413",
              "addressCountry": "US"
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": 33.5779,
              "longitude": -101.8552
            },
            "url": "https://yourwebsite.com/melonie-park",
            "telephone": "+18064414110",
            "openingHours": "Mo-Fr 08:00-17:00",
            "priceRange": "$$"
          }
        `}
      </script>

      {/* SEO Meta Tags - These would typically be in the document head, but included here for component completeness */}
      <Helmet>
        <title>Melonie Park Plumbing Services - Expert Plumbers in Lubbock, TX</title>
        <meta name="description" content="Expert plumbing services in Melonie Park, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more. Local and reliable." />
        <meta name="keywords" content="Melonie Park plumbing, Lubbock plumber, emergency plumbing Melonie Park, water heater repair Lubbock, drain cleaning Melonie Park" />
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to Melonie Park Plumbing Services</h1>
        <p>Your trusted local plumbing experts serving the beautiful Melonie Park neighborhood in Lubbock, TX. Known for its tree-lined streets and family-friendly atmosphere, Melonie Park deserves the best in home services.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in Melonie Park?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Melonie Park's unique plumbing needs, from classic homes to modern renovations.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service to address your plumbing emergencies, minimizing disruption to your family's routine.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Certified and experienced plumbers dedicated to quality workmanship and customer satisfaction.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proud to serve the Melonie Park community, including residents near Miller Elementary and Kastman Park.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Melonie Park</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, major leaks, and urgent plumbing issues in Melonie Park.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance for all types of water heaters, ensuring hot water for your Melonie Park home.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains and sewer lines, keeping your plumbing flowing smoothly.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Melonie Park, Lubbock</h2>
        <p>Melonie Park, developed in the 1960s and '70s, is a well-established and highly sought-after neighborhood in South Lubbock. It's known for its beautiful tree-lined streets, manicured landscapes, and strong community spirit. Residents enjoy easy access to top-rated schools like Miller Elementary, and recreational spots such as Kastman Park and Leroy Elmore Park. Its convenient location near Loop 289 provides quick access to downtown Lubbock, shopping centers, and local dining favorites like Orlando's Italian and Sugar Browns Coffee Co. [1] [2]</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need a Plumber in Melonie Park?</h2>
        <p>Call us today for reliable and professional plumbing services!</p>
        <p className="phone-number">(806) 441-4110</p>
        <button className="housecall-pro-button">Book Now with Housecall Pro</button>
      </section>

      {/* Basic Styling - This would typically be in a separate CSS file or styled-components */}
      <style>{`
        .melonie-park-landing-page {
          font-family: Arial, sans-serif;
          color: #333;
          line-height: 1.6;
        }
        .hero-section {
          background-color: #000;
          color: #fff;
          padding: 60px 20px;
          text-align: center;
        }
        .hero-section h1 {
          color: #e74c3c; /* Red accent */
          margin-bottom: 10px;
        }
        .why-choose-us-section, .services-section, .about-neighborhood-section, .cta-section {
          padding: 40px 20px;
          text-align: center;
        }
        .why-choose-us-section h2, .services-section h2, .about-neighborhood-section h2, .cta-section h2 {
          color: #000;
          margin-bottom: 30px;
        }
        .cards-container {
          display: flex;
          justify-content: center;
          flex-wrap: wrap;
          gap: 20px;
          margin-top: 20px;
        }
        .card {
          background-color: #f4f4f4;
          border: 1px solid #ddd;
          border-radius: 8px;
          padding: 20px;
          width: 280px;
          box-shadow: 0 2px 5px rgba(0,0,0,0.1);
          text-align: left;
        }
        .card h3 {
          color: #e74c3c; /* Red accent */
          margin-bottom: 10px;
        }
        .cta-section {
          background-color: #000;
          color: #fff;
          padding: 50px 20px;
        }
        .cta-section .phone-number {
          font-size: 2em;
          color: #e74c3c; /* Red accent */
          margin: 20px 0;
        }
        .housecall-pro-button {
          background-color: #e74c3c; /* Red accent */
          color: #fff;
          border: none;
          padding: 15px 30px;
          font-size: 1.1em;
          border-radius: 5px;
          cursor: pointer;
          transition: background-color 0.3s ease;
        }
        .housecall-pro-button:hover {
          background-color: #c0392b;
        }
      `}</style>
    </div>
  );
};

export default MeloniePark;

interface HelmetProps {
  children: React.ReactNode;
}

// A dummy Helmet component for demonstration purposes.
// In a real application, you would use a library like react-helmet-async.
const Helmet: React.FC<HelmetProps> = ({ children }) => {
  return <>{children}</>;
};
