import React from 'react';

const MeadowsSouth: React.FC = () => {
  const geoCoordinates = { latitude: 33.5779, longitude: -101.8552 };
  const phoneNumber = '(806) 441-4110';

  return (
    <>
      {/* LocalBusiness Schema Markup */}
      <script type="application/ld+json">
        {
          `{
            "@context": "https://schema.org",
            "@type": "LocalBusiness",
            "name": "Plumbing Services in Meadows South, Lubbock",
            "address": {
              "@type": "PostalAddress",
              "addressLocality": "Lubbock",
              "addressRegion": "TX",
              "postalCode": "79423", // Approximate postal code for South Lubbock
              "streetAddress": ""
            },
            "geo": {
              "@type": "GeoCoordinates",
              "latitude": ${geoCoordinates.latitude},
              "longitude": ${geoCoordinates.longitude}
            },
            "telephone": "${phoneNumber}",
            "url": "https://www.example.com/meadows-south-plumbing"
          }`
        }
      </script>

      {/* SEO Elements */}
      <title>Meadows South Plumbing Services | Expert Plumbers in Lubbock, TX</title>
      <meta name="description" content="Discover reliable plumbing services in Meadows South, Lubbock, TX. From emergency repairs to water heater installations, our expert team is here to help your home."/>
      <meta name="keywords" content="Meadows South plumbing, Lubbock plumbers, emergency plumbing Lubbock, water heater repair Meadows South, drain cleaning Lubbock, local plumbing Meadows South"/>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to Meadows South: Your Trusted Local Plumbers</h1>
        <p>Serving the quiet, family-friendly community of Meadows South in Lubbock, Texas, we provide top-notch plumbing solutions tailored to your neighborhood's needs. Known for its well-kept homes and friendly atmosphere, Meadows South is a wonderful place to live, and we're here to ensure your home's plumbing runs smoothly.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in Meadows South?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Meadows South's specific plumbing infrastructure and common issues.</p>
          </div>
          <div className="card">
            <h3>Prompt Service</h3>
            <p>Quick response times to address your plumbing emergencies, minimizing disruption to your home.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Certified and experienced plumbers dedicated to quality workmanship and customer satisfaction.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proud to serve the Meadows South community, offering reliable and friendly service to our neighbors.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Meadows South</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 rapid response for burst pipes, severe leaks, and urgent plumbing failures in Meadows South.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance for all types of water heaters, ensuring hot water for your family.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains, from kitchen sinks to main sewer lines, keeping your home's plumbing clear.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Meadows South, Lubbock</h2>
        <p>Meadows South is a charming residential neighborhood in Lubbock, TX, celebrated for its quiet streets and welcoming community. Nestled between Frankford and Slide Avenues, just south of 98th Street, it offers a peaceful suburban living experience. Families appreciate the proximity to excellent schools within the Lubbock-Cooper ISD, with West Elementary often within walking distance. The neighborhood's well-maintained homes and cozy culs-de-sacs contribute to its appeal, making it an ideal place for those seeking a friendly and convenient location in Lubbock.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need Plumbing Help in Meadows South?</h2>
        <p>Don't let plumbing issues disrupt your peace of mind. Contact us today for reliable and efficient service!</p>
        <p>Call us at: <a href={`tel:${phoneNumber}`}>{phoneNumber}</a></p>
        <button className="housecall-pro-button">Book Now with Housecall Pro</button>
      </section>

      {/* Basic Styling (to be moved to a CSS file in a real application) */}
      <style>{`
        .hero-section,
        .why-choose-us-section,
        .services-section,
        .about-neighborhood-section,
        .cta-section {
          padding: 40px 20px;
          text-align: center;
        }
        h1, h2 {
          color: #000;
        }
        h3 {
          color: #D32F2F; /* Red */
        }
        p {
          color: #333;
        }
        .cards-container {
          display: flex;
          justify-content: center;
          flex-wrap: wrap;
          gap: 20px;
          margin-top: 20px;
        }
        .card {
          background-color: #f9f9f9;
          border: 1px solid #eee;
          border-radius: 8px;
          padding: 20px;
          width: 280px;
          box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .housecall-pro-button {
          background-color: #D32F2F; /* Red */
          color: #fff;
          border: none;
          padding: 15px 30px;
          font-size: 18px;
          border-radius: 5px;
          cursor: pointer;
          margin-top: 20px;
        }
        .housecall-pro-button:hover {
          background-color: #B71C1C;
        }
      `}</style>
    </>
  );
};

export default MeadowsSouth;
