import React from 'react';
import { Helmet } from 'react-helmet-async';

const MaxeyPark: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProBookingLink = '#'; // Placeholder for actual booking link

  return (
    <div className="maxey-park-landing-page">
      <Helmet>
        <title>Maxey Park Plumbing Services - Expert Plumbers in Lubbock, TX</title>
        <meta name="description" content="Expert plumbing services in Maxey Park, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more. Serving the Maxey Park neighborhood with pride." />
        <meta name="keywords" content="Maxey Park plumbing, Lubbock plumber, emergency plumbing Maxey Park, water heater repair Lubbock, drain cleaning Maxey Park, Maxey Park TX plumbers" />
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "[Your Company Name]",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Street Address]",
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "[Your Postal Code]"
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": "33.5779",
                "longitude": "-101.8552"
              },
              "url": "[Your Website URL]",
              "telephone": "+18064414110",
              "openingHours": "Mo-Fr 08:00-17:00", // Example hours
              "priceRange": "$$"
            }
          `}
        </script>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <div className="container">
          <h1>Expert Plumbing Services in Maxey Park, Lubbock</h1>
          <p>Serving the vibrant Maxey Park neighborhood, known for its beautiful parks and proximity to Texas Tech, with reliable and professional plumbing solutions.</p>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <div className="container">
          <h2>Why Maxey Park Residents Choose Us</h2>
          <div className="cards-grid">
            <div className="card">
              <h3>Local Expertise</h3>
              <p>Deep understanding of Maxey Park's unique plumbing needs, from historic homes to modern constructions near the university.</p>
            </div>
            <div className="card">
              <h3>Rapid Response</h3>
              <p>Quick and efficient service to address your plumbing emergencies, ensuring minimal disruption to your day in this tranquil community.</p>
            </div>
            <div className="card">
              <h3>Trusted Professionals</h3>
              <p>Our certified plumbers are committed to quality workmanship and friendly service, earning the trust of families throughout Maxey Park.</p>
            </div>
            <div className="card">
              <h3>Community Focused</h3>
              <p>Proud to serve a neighborhood that values its green spaces like Maxey Park and its strong community spirit.</p>
            </div>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <div className="container">
          <h2>Our Plumbing Services in Maxey Park</h2>
          <div className="cards-grid">
            <div className="card">
              <h3>Emergency Plumbing</h3>
              <p>24/7 emergency services for burst pipes, severe leaks, and urgent repairs to protect your Maxey Park home.</p>
            </div>
            <div className="card">
              <h3>Water Heaters</h3>
              <p>Installation, repair, and maintenance for all types of water heaters, ensuring comfort for your family near Overton Elementary.</p>
            </div>
            <div className="card">
              <h3>Drain Cleaning</h3>
              <p>Effective solutions for clogged drains and sewer lines, keeping your plumbing flowing smoothly in your Maxey Park residence.</p>
            </div>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <div className="container">
          <h2>About Maxey Park, Lubbock</h2>
          <p>Maxey Park is a cherished Lubbock neighborhood, celebrated for its namesake 100-acre park featuring expansive playgrounds, a scenic lake, and a splash pad – a true gem for families and outdoor enthusiasts. Its quiet, tree-lined streets offer a tranquil environment, a stark contrast to the bustling energy of nearby Texas Tech University. The area boasts a charming mix of older, historically rich homes and newer constructions, reflecting its enduring appeal. Residents benefit from excellent educational opportunities with top-ranked Overton Elementary and highly-rated Hutchinson Middle School within reach. The strong sense of community and dog-friendly atmosphere make Maxey Park an ideal place to live, work, and play.</p>
        </div>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <div className="container">
          <h2>Need a Plumber in Maxey Park?</h2>
          <p>Call us today for reliable and efficient plumbing services.</p>
          <a href={`tel:${phoneNumber}`} className="phone-button">{phoneNumber}</a>
          <a href={housecallProBookingLink} target="_blank" rel="noopener noreferrer" className="booking-button">Book Now with Housecall Pro</a>
        </div>
      </section>

      {/* Basic Styling (for demonstration - integrate with existing site's CSS) */}
      <style>{`
        .maxey-park-landing-page {
          font-family: Arial, sans-serif;
          color: #333;
        }
        .hero-section,
        .why-choose-us-section,
        .services-section,
        .about-neighborhood-section,
        .cta-section {
          padding: 40px 0;
          text-align: center;
        }
        .hero-section {
          background-color: #f0f0f0; /* Light background */
          color: #333;
        }
        .hero-section h1 {
          color: #CC0000; /* Red accent */
        }
        .why-choose-us-section,
        .services-section {
          background-color: #ffffff;
        }
        .about-neighborhood-section {
          background-color: #f0f0f0;
        }
        .cta-section {
          background-color: #333; /* Dark background */
          color: #ffffff;
        }
        .cta-section h2 {
          color: #ffffff;
        }
        .container {
          max-width: 960px;
          margin: 0 auto;
          padding: 0 15px;
        }
        h1, h2 {
          color: #333;
          margin-bottom: 20px;
        }
        h3 {
          color: #CC0000; /* Red accent */
        }
        .cards-grid {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
          gap: 20px;
          margin-top: 30px;
        }
        .card {
          background-color: #f9f9f9;
          border: 1px solid #ddd;
          padding: 20px;
          border-radius: 8px;
          box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .cta-section .phone-button,
        .cta-section .booking-button {
          display: inline-block;
          background-color: #CC0000; /* Red accent */
          color: #ffffff;
          padding: 12px 25px;
          border-radius: 5px;
          text-decoration: none;
          font-weight: bold;
          margin: 10px;
          transition: background-color 0.3s ease;
        }
        .cta-section .phone-button:hover,
        .cta-section .booking-button:hover {
          background-color: #990000;
        }
      `}</style>
    </div>
  );
};

export default MaxeyPark;
