import React from 'react';

const KelseyPark = () => {
  const phoneNumber = '(806) 441-4110';
  const geoCoordinates = { latitude: 33.5779, longitude: -101.8552 };

  return (
    <div className="kelsey-park-landing-page">
      {/* SEO Markup - In a real application, you would use react-helmet or similar for dynamic SEO */}
      <head>
        <title>Kelsey Park Lubbock Plumbing Services | Expert Plumbers for Your Home</title>
        <meta name="description" content="Discover top-rated plumbing services in Kelsey Park, Lubbock. From emergency repairs to water heater installations, our expert team provides reliable solutions for your home. Enjoy peace of mind with local, trusted plumbers." />
        <meta name="keywords" content="Kelsey Park plumbing, Lubbock plumbers, emergency plumbing Kelsey Park, water heater repair Lubbock, drain cleaning Kelsey Park, local plumber Lubbock, Kelsey Park home services" />
        {/* LocalBusiness Schema Markup */}
        <script type="application/ld+json">
          {`
            {
              "@context": "http://schema.org",
              "@type": "LocalBusiness",
              "name": "[Your Business Name]",
              "address": {
                "@type": "PostalAddress",
                "streetAddress": "[Your Street Address]",
                "addressLocality": "Lubbock",
                "addressRegion": "TX",
                "postalCode": "[Your Postal Code]"
              },
              "geo": {
                "@type": "GeoCoordinates",
                "latitude": ${geoCoordinates.latitude},
                "longitude": ${geoCoordinates.longitude}
              },
              "url": "[Your Website URL]",
              "telephone": "+1${phoneNumber.replace(/[^0-9]/g, '')}",
              "openingHours": "Mo-Fr 08:00-17:00",
              "priceRange": "$$"
            }
          `}
        </script>
      </head>

      {/* Hero Section */}
      <section className="hero-section" style={{ backgroundColor: '#000', color: '#fff', padding: '60px 20px', textAlign: 'center' }}>
        <h1 style={{ fontSize: '3em', marginBottom: '10px' }}>Welcome to Kelsey Park</h1>
        <p style={{ fontSize: '1.2em', maxWidth: '800px', margin: '0 auto' }}>
          Welcome to Kelsey Park, a premier residential community nestled in South Lubbock, Texas. Known for its beautifully landscaped grounds, expansive 80+ acre park, and award-winning Lubbock-Cooper ISD schools, Kelsey Park offers a serene and family-friendly environment. Enjoy quiet streets, well-maintained homes, and easy access to local amenities, making it the perfect place to call home.
        </p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section" style={{ padding: '40px 20px', backgroundColor: '#f5f5f5', textAlign: 'center' }}>
        <h2 style={{ fontSize: '2.5em', marginBottom: '40px', color: '#333' }}>Why Choose Us in Kelsey Park</h2>
        <div className="cards-container" style={{ display: 'flex', justifyContent: 'center', flexWrap: 'wrap', gap: '20px' }}>
          <div className="card" style={{ backgroundColor: '#fff', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '280px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Local Kelsey Park Experts</h3>
            <p>As your neighbors in Lubbock, we understand the unique plumbing needs of Kelsey Park homes, ensuring quick and tailored solutions.</p>
          </div>
          <div className="card" style={{ backgroundColor: '#fff', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '280px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Award-Winning Service</h3>
            <p>Our commitment to excellence matches the award-winning schools of LCISD, providing top-tier plumbing services you can trust.</p>
          </div>
          <div className="card" style={{ backgroundColor: '#fff', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '280px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Prompt & Reliable</h3>
            <p>Just like the well-maintained community, our service is always prompt and reliable, ensuring your plumbing issues are resolved efficiently.</p>
          </div>
          <div className="card" style={{ backgroundColor: '#fff', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '280px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Community Focused</h3>
            <p>We're proud to serve the tight-knit Kelsey Park community, offering friendly and professional service that puts your family first.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section" style={{ padding: '40px 20px', backgroundColor: '#fff', textAlign: 'center' }}>
        <h2 style={{ fontSize: '2.5em', marginBottom: '40px', color: '#333' }}>Our Plumbing Services in Kelsey Park</h2>
        <div className="cards-container" style={{ display: 'flex', justifyContent: 'center', flexWrap: 'wrap', gap: '20px' }}>
          <div className="card" style={{ backgroundColor: '#f5f5f5', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '320px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Emergency Plumbing</h3>
            <p>Facing a sudden leak or burst pipe in Kelsey Park? Our emergency team is ready 24/7 to provide rapid and effective solutions.</p>
          </div>
          <div className="card" style={{ backgroundColor: '#f5f5f5', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '320px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Water Heaters</h3>
            <p>From installation to repair, we ensure your Kelsey Park home has a reliable supply of hot water with our expert water heater services.</p>
          </div>
          <div className="card" style={{ backgroundColor: '#f5f5f5', padding: '20px', borderRadius: '8px', boxShadow: '0 2px 5px rgba(0,0,0,0.1)', maxWidth: '320px', textAlign: 'left' }}>
            <h3 style={{ color: '#c00', marginBottom: '10px' }}>Drain Cleaning</h3>
            <p>Keep your home's plumbing flowing smoothly. We offer comprehensive drain cleaning services for all Kelsey Park residences.</p>
          </div>
        </div>
      </section>

      {/* About Kelsey Park Section */}
      <section className="about-kelsey-park-section" style={{ padding: '40px 20px', backgroundColor: '#000', color: '#fff', textAlign: 'center' }}>
        <h2 style={{ fontSize: '2.5em', marginBottom: '20px' }}>About Kelsey Park</h2>
        <div style={{ maxWidth: '900px', margin: '0 auto', textAlign: 'left' }}>
          <p style={{ marginBottom: '15px' }}>
            Kelsey Park boasts approximately 800 single-family lots, an impressive 80+ acre park, and professionally landscaped grounds with mature trees and walking paths. Residents enjoy a low crime rate and a strong sense of community, with regular neighborhood events. The area is highly sought after for its well-maintained homes and lush green spaces.
          </p>
          <p>
            Strategically located in South Lubbock, Kelsey Park offers unparalleled convenience. It's zoned to the highly acclaimed Lubbock-Cooper Independent School District, with Lubbock-Cooper Central Elementary School just minutes away. Residents have easy access to a variety of grocery stores, dining options, shopping centers, and entertainment venues, all within a short drive or even walking distance.
          </p>
        </div>
      </section>

      {/* CTA Section */}
      <section className="cta-section" style={{ padding: '60px 20px', backgroundColor: '#c00', color: '#fff', textAlign: 'center' }}>
        <h2 style={{ fontSize: '2.5em', marginBottom: '20px' }}>Need Plumbing Services in Kelsey Park?</h2>
        <p style={{ fontSize: '1.5em', marginBottom: '30px' }}>Call us today for reliable and expert service!</p>
        <a href={`tel:${phoneNumber.replace(/[^0-9]/g, '')}`} style={{ display: 'inline-block', backgroundColor: '#fff', color: '#c00', padding: '15px 30px', fontSize: '1.5em', borderRadius: '8px', textDecoration: 'none', fontWeight: 'bold', marginRight: '20px' }}>
          {phoneNumber}
        </a>
        <button style={{ backgroundColor: '#000', color: '#fff', padding: '15px 30px', fontSize: '1.5em', borderRadius: '8px', border: 'none', cursor: 'pointer' }}>
          Book Now with Housecall Pro
        </button>
      </section>
    </div>
  );
};

export default KelseyPark;
