import React from 'react';

const GreenAcres: React.FC = () => {
  const schemaMarkup = {
    '@context': 'http://schema.org',
    '@type': 'LocalBusiness',
    'name': 'Plumbing Services Green Acres Lubbock',
    'address': {
      '@type': 'PostalAddress',
      'streetAddress': 'Approximate Location',
      'addressLocality': 'Lubbock',
      'addressRegion': 'TX',
      'postalCode': '79401' // Placeholder, as exact is not provided
    },
    'geo': {
      '@type': 'GeoCoordinates',
      'latitude': 33.5779,
      'longitude': -101.8552
    },
    'url': 'https://yourwebsite.com/green-acres-lubbock-plumbing', // Placeholder
    'telephone': '(806) 441-4110',
    'openingHours': 'Mo-Fr 08:00-17:00', // Example, adjust as needed
    'priceRange': '$$'
  };

  return (
    <div className="green-acres-landing-page">
      <head>
        <title>Green Acres Lubbock Plumbing Services | Expert Plumbers in Green Acres, TX</title>
        <meta name="description" content="Premier plumbing services in Green Acres, Lubbock, TX. We offer emergency plumbing, water heater repair, and drain cleaning with a focus on quality and community. Contact us today!" />
        <meta name="keywords" content="Green Acres plumbing, Lubbock plumbers, emergency plumbing Green Acres, water heater repair Lubbock, drain cleaning Green Acres, Green Acres TX plumbing services" />
        <script type="application/ld+json">
          {JSON.stringify(schemaMarkup)}
        </script>
      </head>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Welcome to Green Acres, Lubbock, TX</h1>
        <p>Welcome to Green Acres, a charming and well-established neighborhood in Lubbock, Texas. Known for its lush greenery, friendly atmosphere, and convenient location, Green Acres offers a peaceful residential experience with easy access to city amenities. Our expert plumbing services are proud to serve the Green Acres community, ensuring comfort and reliability for every home.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Reliable Local Service</h3>
            <p>As your neighbors in Lubbock, we understand the unique plumbing needs of the Green Acres community. We're always ready to provide prompt and efficient service.</p>
          </div>
          <div className="card">
            <h3>Experienced & Certified Technicians</h3>
            <p>Our team consists of highly trained and certified plumbing professionals dedicated to delivering top-quality workmanship and lasting solutions.</p>
          </div>
          <div className="card">
            <h3>Transparent Pricing</h3>
            <p>We believe in honest and upfront pricing. You'll receive a clear estimate before any work begins, with no hidden fees.</p>
          </div>
          <div className="card">
            <h3>Customer Satisfaction Guaranteed</h3>
            <p>Your peace of mind is our priority. We stand behind our work with a satisfaction guarantee, ensuring every job is done right.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Services in Green Acres</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>Available 24/7 for urgent plumbing issues in Green Acres, from burst pipes to severe leaks. Fast response to protect your home.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Expert repair, installation, and maintenance for all types of water heaters, ensuring you always have hot water when you need it.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning & Repair</h3>
            <p>Professional drain cleaning to clear stubborn clogs and comprehensive repair services to keep your plumbing system flowing smoothly.</p>
          </div>
        </div>
      </section>

      {/* About Green Acres Section */}
      <section className="about-neighborhood-section">
        <h2>About Green Acres</h2>
        <p>Green Acres is a vibrant community characterized by its well-maintained homes, mature trees, and a strong sense of neighborhood pride. Residents enjoy a tranquil environment while being just a short drive from Lubbock's shopping, dining, and entertainment options. The neighborhood is also conveniently located near quality schools, such as Hutchinson Middle School, making it an ideal place for families. With its welcoming atmosphere and excellent connectivity, Green Acres truly offers the best of Lubbock living.</p>
      </section>

      {/* Call to Action (CTA) Section */}
      <section className="cta-section">
        <h2>Ready for Expert Plumbing Service?</h2>
        <p>Call us today or book online!</p>
        <a href="tel:8064414110">(806) 441-4110</a>
        <button>Book Now via Housecall Pro</button>
      </section>
    </div>
  );
};

export default GreenAcres;
