import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { MapPin } from "lucide-react";
import { Link } from "wouter";

export default function Gallery() {
  const projects = [
    {
      image: "/images/gallery-1-bathroom-vanity.jpg",
      title: "Modern Bathroom Vanity Installation",
      location: "Lubbock, TX",
      category: "Bathroom Remodel"
    },
    {
      image: "/images/gallery-2-shower-tub.jpg",
      title: "Custom Shower & Clawfoot Tub",
      location: "Lubbock, TX",
      category: "Bathroom Remodel"
    },
    {
      image: "/images/gallery-3-tankless-heater.jpg",
      title: "Tankless Water Heater Installation",
      location: "Lubbock, TX",
      category: "Water Heaters"
    },
    {
      image: "/images/gallery-4-water-heater.jpg",
      title: "Water Heater & Furnace Installation",
      location: "Lubbock, TX",
      category: "Water Heaters"
    },
    {
      image: "/images/gallery-5-bathtub.jpg",
      title: "Freestanding Bathtub Installation",
      location: "Lubbock, TX",
      category: "Bathroom Remodel"
    },
    {
      image: "/images/gallery-6-kitchen-sink.jpg",
      title: "Kitchen Island Sink Installation",
      location: "Lubbock, TX",
      category: "Kitchen Plumbing"
    }
  ];

  return (
    <Layout>
      <SEO 
        title="Plumbing Project Gallery | Cotton City Plumbing Lubbock"
        description="View our recent plumbing projects in Lubbock, Wolfforth, and Slaton. From water heater installations to bathroom remodels, see the quality of our work."
        canonical="/gallery"
      />
      <section className="bg-primary text-white py-16">
        <div className="container text-center">
          <h1 className="font-heading font-extrabold text-4xl md:text-6xl mb-4">Our Work Gallery</h1>
          <p className="text-xl text-primary-foreground/90 max-w-2xl mx-auto">
            See the quality craftsmanship we bring to every job in Lubbock and the surrounding areas.
          </p>
        </div>
      </section>

      <section className="py-16 bg-background">
        <div className="container">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {projects.map((project, index) => (
              <Card key={index} className="overflow-hidden border-none shadow-lg hover:shadow-xl transition-all duration-300 group cursor-pointer">
                <div className="relative aspect-[4/3] overflow-hidden">
                  <img 
                    src={project.image} 
                    alt={project.title} 
                    className="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                </div>
                <CardContent className="p-6">
                  <h3 className="font-heading font-bold text-xl text-primary mb-2 group-hover:text-secondary transition-colors">{project.title}</h3>
                  <div className="flex items-center text-muted-foreground text-sm">
                    <MapPin className="h-4 w-4 mr-1 text-secondary" /> {project.location}
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>

          <div className="mt-16 bg-black/90 rounded-none p-8 md:p-12 text-center">
            <h2 className="font-heading font-bold text-3xl text-primary uppercase italic mb-4">Ready to Start Your Project?</h2>
            <p className="text-lg text-white mb-8 max-w-2xl mx-auto">
              Whether it's a simple repair or a major installation, we're ready to help. Contact us today for a free estimate.
            </p>
            <div className="flex flex-col sm:flex-row justify-center gap-4">
              <a href="tel:8064414110">
                <Button size="lg" className="bg-primary hover:bg-primary/90 text-white font-bold text-lg px-8 py-6 shadow-xl w-full sm:w-auto uppercase rounded-none">
                  Call (806) 441-4110
                </Button>
              </a>
              <Link href="/contact">
                <Button size="lg" className="bg-primary hover:bg-primary/90 text-white font-bold text-lg px-8 py-6 w-full sm:w-auto uppercase rounded-none shadow-xl">
                  Book Online Now
                </Button>
              </Link>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
