import { Helmet } from 'react-helmet-async';
import React from 'react';

const DunbarManhattanHeights: React.FC = () => {
  const phoneNumber = '(806) 441-4110';
  const housecallProBookingLink = '#'; // Placeholder for Housecall Pro booking link

  const schemaMarkup = {
    '@context': 'http://schema.org',
    '@type': 'LocalBusiness',
    'name': 'Plumbing Services in Dunbar-Manhattan Heights, Lubbock, TX',
    'address': {
      '@type': 'PostalAddress',
      'addressLocality': 'Lubbock',
      'addressRegion': 'TX',
      'postalCode': '79403', // Approximate postal code for the area
      'streetAddress': 'Dunbar-Manhattan Heights Neighborhood'
    },
    'geo': {
      '@type': 'GeoCoordinates',
      'latitude': 33.5779,
      'longitude': -101.8552
    },
    'telephone': phoneNumber,
    'url': 'https://example.com/dunbar-manhattan-heights' // Placeholder URL
  };

  return (
    <div className="dunbar-manhattan-heights-landing-page">
      <script type="application/ld+json">
        {JSON.stringify(schemaMarkup)}
      </script>

      {/* SEO Meta Tags */}
      <Helmet>
        <title>Dunbar-Manhattan Heights Plumbing Services | Expert Plumbers in Lubbock, TX</title>
        <meta name="description" content="Expert plumbing services in Dunbar-Manhattan Heights, Lubbock, TX. We offer emergency plumbing, water heater repair, drain cleaning, and more. Local and reliable."/>
        <meta name="keywords" content="Dunbar-Manhattan Heights plumbing, Lubbock plumbers, emergency plumbing Lubbock, water heater repair Lubbock, drain cleaning Lubbock, local plumbing services"/>
      </Helmet>

      {/* Hero Section */}
      <section className="hero-section">
        <h1>Expert Plumbing Services in Dunbar-Manhattan Heights</h1>
        <p>Your trusted local plumbers serving the historic Dunbar-Manhattan Heights neighborhood in East Lubbock. We're here for all your plumbing needs, from routine maintenance to emergency repairs.</p>
      </section>

      {/* Why Choose Us Section */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us for Your Dunbar-Manhattan Heights Home?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Dunbar-Manhattan Heights' unique plumbing needs, considering the area's history and infrastructure.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service to the Dunbar-Manhattan Heights community, especially for urgent plumbing issues.</p>
          </div>
          <div className="card">
            <h3>Trusted Professionals</h3>
            <p>Experienced and certified plumbers dedicated to quality service in your neighborhood.</p>
          </div>
          <div className="card">
            <h3>Community Focused</h3>
            <p>Proud to serve the residents of Dunbar-Manhattan Heights, contributing to the well-being of our community.</p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="services-section">
        <h2>Our Plumbing Services in Dunbar-Manhattan Heights</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 emergency services for burst pipes, severe leaks, and urgent plumbing issues in Dunbar-Manhattan Heights.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance of water heaters to ensure comfort in your Dunbar-Manhattan Heights home.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective drain cleaning solutions for clogged sinks, toilets, and main sewer lines, keeping your plumbing flowing smoothly.</p>
          </div>
        </div>
      </section>

      {/* About Neighborhood Section */}
      <section className="about-neighborhood-section">
        <h2>About Dunbar-Manhattan Heights, Lubbock, TX</h2>
        <p>The Dunbar-Manhattan Heights neighborhood, located in East Lubbock, holds a rich history and a strong sense of community. Known for its quiet streets, well-kept yards, and welcoming atmosphere, it's a place residents are proud to call home. The area benefits from green spaces like Mae Simmons Park, offering recreational opportunities for families. Education is also a focus, with institutions like Dunbar College Preparatory Academy serving the youth. Despite a challenging past, including recovery from the 1970 tornado, the neighborhood has rebuilt and thrives, offering convenient access to major transportation routes like U.S. Highway 84, connecting residents to all that Lubbock has to offer.</p>
      </section>

      {/* CTA Section */}
      <section className="cta-section">
        <h2>Need a Plumber in Dunbar-Manhattan Heights?</h2>
        <p>Call us today for reliable and professional plumbing services!</p>
        <a href={`tel:${phoneNumber}`} className="phone-number-button">{phoneNumber}</a>
        <a href={housecallProBookingLink} target="_blank" rel="noopener noreferrer" className="housecall-pro-button">Book Now with Housecall Pro</a>
      </section>

      {/* Basic Styling (to be replaced with actual site design) */}
      <style>{`
        .dunbar-manhattan-heights-landing-page {
          font-family: Arial, sans-serif;
          color: #333;
          line-height: 1.6;
        }
        .hero-section {
          background-color: #000;
          color: #fff;
          padding: 60px 20px;
          text-align: center;
        }
        .hero-section h1 {
          color: #e30000; /* Red accent */
          margin-bottom: 10px;
        }
        .why-choose-us-section, .services-section, .about-neighborhood-section, .cta-section {
          padding: 40px 20px;
          text-align: center;
        }
        .why-choose-us-section h2, .services-section h2, .about-neighborhood-section h2, .cta-section h2 {
          color: #e30000; /* Red accent */
          margin-bottom: 30px;
        }
        .cards-container {
          display: flex;
          justify-content: center;
          flex-wrap: wrap;
          gap: 20px;
          margin-top: 20px;
        }
        .card {
          background-color: #f4f4f4;
          border: 1px solid #ddd;
          border-radius: 8px;
          padding: 20px;
          width: 280px;
          box-shadow: 0 2px 5px rgba(0,0,0,0.1);
          text-align: left;
        }
        .card h3 {
          color: #000;
          margin-top: 0;
          margin-bottom: 10px;
        }
        .phone-number-button, .housecall-pro-button {
          display: inline-block;
          background-color: #e30000; /* Red */
          color: #fff;
          padding: 12px 25px;
          border-radius: 5px;
          text-decoration: none;
          margin: 10px;
          font-weight: bold;
        }
        .phone-number-button:hover, .housecall-pro-button:hover {
          background-color: #c00;
        }
      `}</style>
    </div>
  );
};

export default DunbarManhattanHeights;
