import { Helmet } from 'react-helmet-async';
import React from 'react';

const ClappPark: React.FC = () => {
  const localBusinessSchema = {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "Clapp Park Plumbing Services",
    "address": {
      "@type": "PostalAddress",
      "addressLocality": "Lubbock",
      "addressRegion": "TX",
      "postalCode": "79401", // Approximate, will need to refine
      "streetAddress": "Clapp Park Area"
    },
    "geo": {
      "@type": "GeoCoordinates",
      "latitude": 33.5779,
      "longitude": -101.8552
    },
    "telephone": "(806) 441-4110",
    "url": "https://yourwebsite.com/clapp-park", // Placeholder
    "image": "https://yourwebsite.com/clapp-park-hero.jpg", // Placeholder
    "priceRange": "$$",
    "servesCuisine": "Plumbing Services",
    "openingHoursSpecification": [
      {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday"
        ],
        "opens": "08:00",
        "closes": "17:00"
      }
    ]
  };

  return (
    <div className="clapp-park-landing-page">
      {/* LocalBusiness Schema Markup */}
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{ __html: JSON.stringify(localBusinessSchema) }}
      />

      {/* SEO-optimized title, meta description, and keywords */}
      <Helmet>
        <title>Clapp Park Plumbing Services - Expert Plumbers in Lubbock, TX</title>
        <meta name="description" content="Expert plumbing services in Clapp Park, Lubbock, TX. Emergency plumbing, water heater repair, drain cleaning, and more. Local and reliable." />
        <meta name="keywords" content="Clapp Park plumbing, Lubbock plumber, emergency plumbing Clapp Park, water heater repair Lubbock, drain cleaning Lubbock" />
      </Helmet>

      {/* Hero section with neighborhood name and description */}
      <section className="hero-section">
        <h1>Welcome to Clapp Park, Lubbock</h1>
        <p>Your trusted local plumbing experts serving the Clapp Park neighborhood and surrounding areas in Lubbock, TX. We're dedicated to providing top-notch plumbing solutions with a friendly, professional touch.</p>
      </section>

      {/* 
      {/* "Why Choose Us" section with 4 cards highlighting service benefits */}
      <section className="why-choose-us-section">
        <h2>Why Choose Us in Clapp Park?</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Local Expertise</h3>
            <p>Deep understanding of Clapp Park's plumbing infrastructure and common issues.</p>
          </div>
          <div className="card">
            <h3>Rapid Response</h3>
            <p>Quick and efficient service to address your plumbing emergencies.</p>
          </div>
          <div className="card">
            <h3>Certified Professionals</h3>
            <p>Experienced and licensed plumbers dedicated to quality workmanship.</p>
          </div>
          <div className="card">
            <h3>Transparent Pricing</h3>
            <p>Clear, upfront pricing with no hidden fees, ensuring peace of mind.</p>
          </div>
        </div>
      </section>

      {/* Services section with 3 service cards */}
      <section className="services-section">
        <h2>Our Plumbing Services in Clapp Park</h2>
        <div className="cards-container">
          <div className="card">
            <h3>Emergency Plumbing</h3>
            <p>24/7 availability for burst pipes, major leaks, and urgent repairs.</p>
          </div>
          <div className="card">
            <h3>Water Heater Services</h3>
            <p>Installation, repair, and maintenance of all types of water heaters.</p>
          </div>
          <div className="card">
            <h3>Drain Cleaning</h3>
            <p>Effective solutions for clogged drains, from sinks to main sewer lines.</p>
          </div>
        </div>
      </section>

      {/* "About [Neighborhood]" section with community features and location benefits */}
      <section className="about-neighborhood-section">
        <h2>About Clapp Park, Lubbock</h2>
        <p>Clapp Park is a vibrant and established neighborhood in Lubbock, Texas, known for its beautiful green spaces and family-friendly atmosphere. With its proximity to local amenities like Clapp Park itself, residents enjoy easy access to recreational activities and community events. Our services extend throughout this wonderful area, ensuring that every home in Clapp Park receives the best plumbing care.</p>
        <p>The neighborhood boasts excellent schools and convenient access to major roadways, making it an ideal location for families and professionals alike. We are proud to serve the Clapp Park community, contributing to its comfort and well-being with reliable plumbing solutions.</p>
      </section>

      {/* CTA section with phone number and Housecall Pro booking button */}
      <section className="cta-section">
        <h2>Need a Plumber in Clapp Park?</h2>
        <p>Call us today for reliable and efficient plumbing services!</p>
        <p className="phone-number">(806) 441-4110</p>
        <a href="https://www.housecallpro.com/book/your-company-name" target="_blank" rel="noopener noreferrer" className="booking-button">Book Now with Housecall Pro</a>
      </section>
    </div>
  );
};

export default ClappPark;
