import React from 'react';

const Cimarron: React.FC = () => {
  const localBusinessSchema = {
    '@context': 'https://schema.org',
    '@type': 'LocalBusiness',
    name: 'Cimarron Plumbing Services',
    address: {
      '@type': 'PostalAddress',
      addressLocality: 'Lubbock',
      addressRegion: 'TX',
      postalCode: '79407',
      streetAddress: 'Cimarron, Lubbock, TX',
    },
    geo: {
      '@type': 'GeoCoordinates',
      latitude: 33.5779,
      longitude: -101.8552,
    },
    telephone: '806-441-4110',
    url: 'https://www.yourwebsite.com/cimarron',
    serviceType: 'Plumbing Services',
    areaServed: {
      '@type': 'City',
      name: 'Lubbock',
    },
  };

  return (
    <div className="bg-black text-white">
      <script type="application/ld+json">{JSON.stringify(localBusinessSchema)}</script>
      <header className="bg-gray-900 text-center py-20">
        <h1 className="text-5xl font-bold">Cimarron</h1>
        <p className="text-xl mt-4">Your Trusted Plumbing Partner in Cimarron, Lubbock</p>
        <p className="mt-2">Serving the tranquil and family-friendly Cimarron neighborhood with expert plumbing solutions. From routine maintenance to urgent repairs, we're here for your home.</p>
        <a href="#" className="bg-red-600 text-white font-bold py-3 px-6 mt-6 inline-block rounded">Schedule Service Now</a>
      </header>

      <section className="py-20 px-4">
        <h2 className="text-4xl font-bold text-center mb-12">Why Choose Us</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">Cimarron Local Experts</h3>
            <p>Deep understanding of Cimarron's unique plumbing needs and community standards. We're your neighbors, ready to help.</p>
          </div>
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">Fast & Reliable Service</h3>
            <p>Quick and efficient service to address your plumbing emergencies, minimizing disruption to your Cimarron home life.</p>
          </div>
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">Guaranteed Quality</h3>
            <p>Professional, high-quality plumbing solutions backed by our commitment to excellence and lasting results for Cimarron residents.</p>
          </div>
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">Dedicated to Cimarron</h3>
            <p>Proudly serving the Cimarron community, contributing to the comfort and well-being of our local residents.</p>
          </div>
        </div>
      </section>

      <section className="bg-gray-900 py-20 px-4">
        <h2 className="text-4xl font-bold text-center mb-12">Our Services</h2>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">24/7 Emergency Plumbing</h3>
            <p>Burst pipes, severe leaks, or sudden clogs? Our emergency team is ready to respond swiftly to protect your Cimarron home.</p>
          </div>
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">Water Heater Services</h3>
            <p>Expert repair, maintenance, and installation for all types of water heaters, ensuring consistent hot water for your family in Cimarron.</p>
          </div>
          <div className="bg-gray-800 p-6 rounded-lg text-center">
            <h3 className="text-2xl font-bold mb-2">Professional Drain Cleaning</h3>
            <p>Effective solutions for clogged drains, from kitchen sinks to main sewer lines, keeping your Cimarron home's plumbing flowing freely.</p>
          </div>
        </div>
      </section>

      <section className="py-20 px-4">
        <h2 className="text-4xl font-bold text-center mb-12">About Cimarron</h2>
        <div className="max-w-4xl mx-auto text-lg">
          <p className="mb-4">Cimarron South, a charming neighborhood in Lubbock, offers a blend of suburban tranquility and urban convenience. Located in South Lubbock, this family-friendly community features well-maintained homes primarily built since the early 2000s.</p>
          <p className="mb-4">Residents enjoy easy access to shopping centers, parks, and top-rated Frenship ISD schools. The neighborhood comes alive with community events at nearby McKenzie Park, fostering a strong sense of belonging.</p>
          <p>Tree-lined streets and spacious lots create an ideal setting for evening strolls and outdoor activities, making Cimarron South a perfect choice for those seeking a balanced lifestyle in Lubbock.</p>
        </div>
      </section>

      <section className="bg-red-600 text-white text-center py-20">
        <h2 className="text-4xl font-bold">Ready for Reliable Plumbing in Cimarron?</h2>
        <p className="text-2xl mt-4">Call us now at (806) 441-4110</p>
        <a href="#" className="bg-white text-red-600 font-bold py-3 px-6 mt-6 inline-block rounded">Book Now with Housecall Pro</a>
      </section>
    </div>
  );
};

export default Cimarron;
