import Layout from "@/components/Layout";
import SEO from "@/components/SEO";
import { blogPosts } from "@/data/blogPosts";
import { Calendar, ChevronLeft, User } from "lucide-react";
import { Link, useRoute } from "wouter";
import NotFound from "./NotFound";

export default function BlogPost() {
  const [match, params] = useRoute("/blog/:slug");
  
  if (!match) return <NotFound />;
  
  const post = blogPosts.find(p => p.slug === params.slug);
  
  if (!post) return <NotFound />;

  return (
    <Layout>
      <SEO 
        title={`${post.title} | Cotton City Plumbing Blog`}
        description={post.excerpt}
        keywords="plumbing blog, lubbock plumbing tips"
      />
      
      <div className="bg-zinc-900 py-12">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <Link href="/blog">
              <span className="inline-flex items-center text-gray-400 hover:text-white mb-6 transition-colors cursor-pointer">
                <ChevronLeft className="w-4 h-4 mr-1" /> Back to Blog
              </span>
            </Link>
            <h1 className="text-3xl md:text-5xl font-league-gothic text-white mb-4 uppercase tracking-wide leading-tight">
              {post.title}
            </h1>
            <div className="flex items-center text-gray-400 text-sm space-x-6">
              <div className="flex items-center">
                <Calendar className="w-4 h-4 mr-2" />
                {new Date(post.date).toLocaleDateString()}
              </div>
              <div className="flex items-center">
                <User className="w-4 h-4 mr-2" />
                {post.author}
              </div>
            </div>
          </div>
        </div>
      </div>

      <div className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <article className="max-w-3xl mx-auto prose prose-lg prose-red">
            <div dangerouslySetInnerHTML={{ __html: post.content }} />
          </article>
          
          <div className="max-w-3xl mx-auto mt-12 pt-8 border-t border-gray-200">
            <div className="bg-gray-50 p-8 rounded-lg text-center">
              <h3 className="text-2xl font-league-gothic uppercase tracking-wide mb-2">Need Help with This Issue?</h3>
              <p className="text-gray-600 mb-6">Our expert team is ready to assist you with any plumbing challenge.</p>
              <Link href="/contact">
                <span className="inline-block bg-red-600 text-white font-bold py-3 px-8 rounded hover:bg-red-700 transition-colors uppercase tracking-wider cursor-pointer">
                  Contact Us Today
                </span>
              </Link>
            </div>
          </div>
        </div>
      </div>
    </Layout>
  );
}
