import React from 'react';

const ArnettBenson: React.FC = () => {
  const schemaMarkup = {
    "@context": "http://schema.org",
    "@type": "LocalBusiness",
    "name": "[Your Business Name]", // Placeholder
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "[Your Street Address]", // Placeholder
      "addressLocality": "Lubbock",
      "addressRegion": "TX",
      "postalCode": "79415",
      "addressCountry": "US"
    },
    "geo": {
      "@type": "GeoCoordinates",
      "latitude": 33.5779,
      "longitude": -101.8552
    },
    "url": "[Your Website URL]", // Placeholder
    "telephone": "+18064414110",
    "openingHours": "Mo-Fr 08:00-17:00", // Example
    "priceRange": "$$", // Example
    "image": "[URL to your business logo or relevant image]", // Placeholder
    "description": "Premier plumbing services in Arnett Benson, Lubbock, TX. We offer emergency plumbing, water heater repair, and drain cleaning."
  };

  return (
    <div className="font-sans text-secondary bg-accent">
      {/* SEO */} 
      <title>Arnett Benson Plumbing Services | Expert Plumbers in Lubbock, TX</title>
      <meta name="description" content="Premier plumbing services in Arnett Benson, Lubbock, TX. We offer emergency plumbing, water heater repair, and drain cleaning. Serving the close-knit community of Arnett Benson with reliable and professional solutions." />
      <meta name="keywords" content="Arnett Benson plumbing, Lubbock plumbers, emergency plumbing Arnett Benson, water heater repair Lubbock, drain cleaning Arnett Benson, Arnett Benson community, Lubbock TX plumbing" />

      {/* Schema Markup */}
      <script type="application/ld+json">
        {JSON.stringify(schemaMarkup)}
      </script>

      {/* Hero Section */}
      <section className="bg-primary text-accent py-20">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-5xl font-bold mb-4">Your Trusted Plumbing Partner in Arnett Benson, Lubbock</h1>
          <p className="text-xl">
            Serving the vibrant and close-knit community of Arnett Benson, our expert plumbers provide top-notch service with a friendly touch. From the historic charm of midcentury ranch-style homes to the bustling activity around Texas Tech, we understand the unique needs of this North Lubbock neighborhood. We're proud to be part of a community that values connection through its schools and churches, and we're committed to delivering reliable plumbing solutions that keep your home comfortable and safe.
          </p>
        </div>
      </section>

      {/* Why Choose Us Section */}
      <section className="py-20 bg-accent">
        <div className="container mx-auto px-4">
          <h2 className="text-4xl font-bold text-center mb-12">Why Choose Us</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Local Expertise</h3>
              <p>Deep understanding of Arnett Benson's diverse housing, from classic ranch homes to student apartments near Texas Tech, ensuring tailored solutions.</p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Community Focused</h3>
              <p>We're part of the Lubbock fabric, dedicated to serving our neighbors in Arnett Benson with integrity and a commitment to local well-being.</p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Rapid Response</h3>
              <p>Quick and efficient service for all your plumbing emergencies, minimizing disruption to your family life in this lively community.</p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Quality Workmanship</h3>
              <p>Certified professionals delivering lasting plumbing solutions, backed by our commitment to excellence for every Arnett Benson home.</p>
            </div>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="py-20 bg-gray-100">
        <div className="container mx-auto px-4">
          <h2 className="text-4xl font-bold text-center mb-12">Our Services</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Emergency Plumbing</h3>
              <p>Fast and reliable emergency plumbing services for unexpected leaks, bursts, and blockages, available 24/7 to protect your Arnett Benson home.</p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Water Heater Repair & Installation</h3>
              <p>Expert repair, maintenance, and installation of water heaters, ensuring consistent hot water for your family, whether you're near Rodgers Park or Texas Tech.</p>
            </div>
            <div className="bg-white p-6 rounded-lg shadow-lg text-center">
              <h3 className="text-xl font-semibold mb-4">Drain Cleaning & Unclogging</h3>
              <p>Thorough drain cleaning services to clear stubborn clogs and prevent future issues, keeping your plumbing system flowing smoothly in Arnett Benson.</p>
            </div>
          </div>
        </div>
      </section>

      {/* About Arnett Benson Section */}
      <section className="py-20 bg-accent">
        <div className="container mx-auto px-4">
          <h2 className="text-4xl font-bold text-center mb-12">Discover the Heart of Arnett Benson, Lubbock</h2>
          <p className="text-lg leading-relaxed text-center">
            Arnett Benson is more than just a neighborhood; it's a community rich in history and vibrant with activity. Located on Lubbock's north side, it's home to excellent educational institutions like the B-rated Wolffarth Elementary, known for its top performance, and McWhorter Elementary. The neighborhood boasts recreational gems like Rodgers Park, featuring the Maggie Trejo Supercenter and a new splash pad, and is less than a mile from the Buddy Holly Lake Recreation Area, famous for its 'Vamos a Pescar' event. Residents enjoy easy access to family-owned eateries like Joel's Mexican Restaurant and Montelongo's, reflecting the area's diverse cultural history. With Texas Tech University just to the south and downtown Lubbock a mere 3 miles away, Arnett Benson offers a perfect blend of community spirit, educational opportunities, and convenient city access.
          </p>
        </div>
      </section>

      {/* CTA Section */}
      <section className="bg-primary text-accent py-20 text-center">
        <div className="container mx-auto px-4">
          <h2 className="text-4xl font-bold mb-8">Ready for Reliable Plumbing Service?</h2>
          <p className="text-2xl mb-8">Call us today for a free estimate!</p>
          <a href="tel:+18064414110" className="bg-accent text-primary hover:bg-gray-200 text-2xl font-bold py-4 px-8 rounded-full transition duration-300 ease-in-out">
            (806) 441-4110
          </a>
          {/* Housecall Pro Booking Button - Placeholder for integration */}
          <button className="ml-4 bg-white text-primary hover:bg-gray-200 text-2xl font-bold py-4 px-8 rounded-full transition duration-300 ease-in-out">
            Book Now (Housecall Pro)
          </button>
        </div>
      </section>
    </div>
  );
};

export default ArnettBenson;
