export interface JobPin {
  id: string;
  technician: string;
  date: string;
  title: string;
  description: string;
  location: {
    lat: number;
    lng: number;
    city: string;
    state: string;
  };
  images: string[];
}

export const recentJobs: JobPin[] = [
  {
    id: "1",
    technician: "Mike D.",
    date: "2025-12-05",
    title: "Water Heater Replacement",
    description: "Replaced a leaking 40-gallon gas water heater with a new high-efficiency Rheem unit. Verified proper venting and gas pressure.",
    location: {
      lat: 33.5779,
      lng: -101.8552,
      city: "Lubbock",
      state: "TX"
    },
    images: ["/images/hero-truck.png"]
  },
  {
    id: "2",
    technician: "Sarah L.",
    date: "2025-12-04",
    title: "Sewer Line Repair",
    description: "Located and repaired a broken sewer line caused by tree root intrusion. Installed a cleanout for future maintenance.",
    location: {
      lat: 33.5600,
      lng: -101.9200,
      city: "Wolfforth",
      state: "TX"
    },
    images: ["/images/hero-truck.png"]
  },
  {
    id: "3",
    technician: "David R.",
    date: "2025-12-03",
    title: "Tankless Water Heater Install",
    description: "Installed a new Navien tankless water heater for endless hot water. Upgraded gas line to support the new unit.",
    location: {
      lat: 33.5200,
      lng: -101.8800,
      city: "Lubbock",
      state: "TX"
    },
    images: ["/images/hero-truck.png"]
  },
  {
    id: "4",
    technician: "Mike D.",
    date: "2025-12-02",
    title: "Emergency Drain Cleaning",
    description: "Cleared a stubborn kitchen sink clog using a hydro-jetter. Restored full flow to the kitchen drain.",
    location: {
      lat: 33.5900,
      lng: -101.8300,
      city: "Lubbock",
      state: "TX"
    },
    images: ["/images/hero-truck.png"]
  },
  {
    id: "5",
    technician: "Chris P.",
    date: "2025-12-01",
    title: "Whole House Repipe",
    description: "Completed a PEX repipe for a 3-bedroom home to replace old galvanized pipes. Improved water pressure and water quality.",
    location: {
      lat: 33.4900,
      lng: -101.8000,
      city: "Slaton",
      state: "TX"
    },
    images: ["/images/hero-truck.png"]
  },
  {
    id: "6",
    technician: "Sarah L.",
    date: "2025-11-30",
    title: "Water Softener Installation",
    description: "Installed a whole-home water softener to combat hard water issues. Tested water hardness before and after installation.",
    location: {
      lat: 33.6800,
      lng: -101.9900,
      city: "Shallowater",
      state: "TX"
    },
    images: ["/images/hero-truck.png"]
  }
];
