import { Button } from "@/components/ui/button";
import { Facebook, Instagram, Share2 } from "lucide-react";

interface SocialShareButtonsProps {
  url: string;
  title: string;
  description?: string;
}

export default function SocialShareButtons({ url, title, description }: SocialShareButtonsProps) {
  const fullUrl = `https://cottoncityplumbing.com${url}`;
  const encodedUrl = encodeURIComponent(fullUrl);
  const encodedTitle = encodeURIComponent(title);
  const encodedDescription = description ? encodeURIComponent(description) : '';

  const shareFacebook = () => {
    const facebookUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodedUrl}`;
    window.open(facebookUrl, '_blank', 'width=600,height=400');
  };

  const copyLink = () => {
    navigator.clipboard.writeText(fullUrl);
    // You could add a toast notification here
    alert('Link copied to clipboard!');
  };

  return (
    <div className="flex flex-col gap-4">
      <div className="flex items-center gap-2">
        <Share2 className="h-5 w-5 text-gray-600" />
        <span className="font-bold text-gray-900">Share this article:</span>
      </div>
      
      <div className="flex flex-wrap gap-3">
        <Button
          onClick={shareFacebook}
          variant="outline"
          className="flex items-center gap-2 hover:bg-[#1877F2] hover:text-white hover:border-[#1877F2] transition-colors"
        >
          <Facebook className="h-5 w-5" />
          <span>Share on Facebook</span>
        </Button>

        <Button
          onClick={copyLink}
          variant="outline"
          className="flex items-center gap-2 hover:bg-primary hover:text-white hover:border-primary transition-colors"
        >
          <Share2 className="h-5 w-5" />
          <span>Copy Link</span>
        </Button>
      </div>

      <div className="mt-4 pt-4 border-t border-gray-200">
        <p className="text-sm text-gray-600 mb-3">Follow us on social media:</p>
        <div className="flex gap-3">
          <a
            href="https://www.facebook.com/CottonCityPlumbing"
            target="_blank"
            rel="noopener noreferrer"
            className="flex items-center gap-2 px-4 py-2 rounded-md bg-[#1877F2] text-white hover:bg-[#1877F2]/90 transition-colors"
          >
            <Facebook className="h-5 w-5" />
            <span className="font-semibold">Facebook</span>
          </a>
          
          <a
            href="https://www.instagram.com/cottoncityplumbing"
            target="_blank"
            rel="noopener noreferrer"
            className="flex items-center gap-2 px-4 py-2 rounded-md bg-gradient-to-r from-[#833AB4] via-[#FD1D1D] to-[#F77737] text-white hover:opacity-90 transition-opacity"
          >
            <Instagram className="h-5 w-5" />
            <span className="font-semibold">Instagram</span>
          </a>
        </div>
      </div>
    </div>
  );
}
