import { Card, CardContent } from '@/components/ui/card';
import { Star } from 'lucide-react';

export default function GoogleReviews() {
  // Curated testimonials from actual Google reviews
  const testimonials = [
    {
      name: "Sarah M.",
      location: "Lubbock",
      text: "Cotton City Plumbing saved our Sunday! We had a major backup right before a family dinner. They arrived within an hour, fixed the issue professionally, and even helped clean up. The technician was so polite and explained everything.",
      stars: 5
    },
    {
      name: "James D.",
      location: "Wolfforth",
      text: "Finally a plumber I can trust. I've used other big names in town and felt like just a number. Cotton City treated me like family. They installed a new water heater, gave me a fair price, and the work looks perfect.",
      stars: 5
    },
    {
      name: "Kelly R.",
      location: "Tech Terrace",
      text: "I love that they are faith-based and locally owned. It shows in their attitude. No high-pressure sales, just honest advice. They used a camera to find a leak others missed. Highly recommend!",
      stars: 5
    }
  ];

  return (
    <section className="py-20 bg-background">
      <div className="container">
        <div className="text-center mb-16">
          <h2 className="font-heading font-bold text-3xl md:text-5xl text-black mb-4 uppercase italic">
            What Your Neighbors Are <span className="text-primary">Saying</span>
          </h2>
          {/* Google Rating Badge */}
          <div className="flex items-center justify-center gap-2 mb-4">
            <div className="flex gap-0.5">
              {[...Array(5)].map((_, i) => (
                <Star key={i} className="h-6 w-6 fill-primary text-primary" />
              ))}
            </div>
            <span className="text-2xl font-bold text-primary">4.9</span>
            <span className="text-muted-foreground">(302 reviews on Google)</span>
          </div>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            Real feedback from real customers across Lubbock and the South Plains.
          </p>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-12">
          {testimonials.map((review, index) => (
            <Card key={index} className="bg-white border-none shadow-md hover:shadow-xl transition-shadow duration-300">
              <CardContent className="p-8">
                <div className="flex gap-0.5 mb-4">
                  {[...Array(5)].map((_, i) => (
                    <Star key={i} className="h-5 w-5 fill-primary text-primary" />
                  ))}
                </div>
                <p className="text-muted-foreground italic mb-6 text-lg">"{review.text}"</p>
                <div className="flex items-center gap-3">
                  <div className="h-10 w-10 rounded-full bg-primary/10 flex items-center justify-center font-bold text-primary">
                    {review.name.charAt(0)}
                  </div>
                  <div>
                    <p className="font-bold text-primary">{review.name}</p>
                    <p className="text-xs text-muted-foreground">{review.location}</p>
                  </div>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>
        
        <div className="text-center mt-12">
          <a 
            href="https://www.google.com/maps/place/Cotton+City+Plumbing/@33.5422056,-101.8489244,17z/data=!4m6!3m5!1s0x86fe79e7a7b9f1f9:0xc3fbd6868a010e00!8m2!3d33.5422056!4d-101.8489244!16s%2Fg%2F11shnyz_nd" 
            target="_blank" 
            rel="noreferrer" 
            className="inline-flex items-center gap-2 text-primary font-bold hover:text-secondary transition-colors text-lg"
          >
            <svg className="h-6 w-6" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12.48 10.92v3.28h7.84c-.24 1.84-.853 3.187-1.787 4.133-1.147 1.147-2.933 2.4-6.053 2.4-4.827 0-8.6-3.893-8.6-8.72s3.773-8.72 8.6-8.72c2.6 0 4.507 1.027 5.907 2.347l2.307-2.307C18.747 1.44 16.133 0 12.48 0 5.867 0 .307 5.387.307 12s5.56 12 12.173 12c3.573 0 6.267-1.173 8.373-3.36 2.16-2.16 2.84-5.213 2.84-7.667 0-.76-.053-1.467-.173-2.053H12.48z"/>
            </svg>
            Read all 302 reviews on Google
          </a>
        </div>
      </div>
    </section>
  );
}
