# Google Search Console Setup Guide
## Cotton City Plumbing Website

This guide will walk you through submitting your sitemap to Google Search Console for faster indexing and better search visibility.

---

## What is Google Search Console?

Google Search Console is a free tool that helps you monitor and maintain your website's presence in Google search results. By submitting your sitemap, you tell Google about all the pages on your website, which helps them get indexed faster.

---

## Step 1: Access Google Search Console

1. Go to [https://search.google.com/search-console](https://search.google.com/search-console)
2. Sign in with your Google account (use the same account associated with your business)
3. If this is your first time, you'll see a welcome screen

---

## Step 2: Add Your Property

### Option A: Domain Property (Recommended)
1. Click **"Add Property"** in the top-left corner
2. Select **"Domain"** option
3. Enter your domain: `cottoncityplumbing.com` (without https:// or www)
4. Click **"Continue"**

### Option B: URL Prefix Property
1. Click **"Add Property"**
2. Select **"URL prefix"** option
3. Enter: `https://www.cottoncityplumbing.com`
4. Click **"Continue"**

---

## Step 3: Verify Ownership

Google will provide several verification methods. The easiest for your Manus-hosted site:

### Method 1: HTML Tag (Recommended)
1. Google will show you a meta tag like this:
   ```html
   <meta name="google-site-verification" content="YOUR_VERIFICATION_CODE" />
   ```
2. **Copy the entire tag**
3. Send this tag to me (Manus AI) and I'll add it to your website's `<head>` section
4. After I confirm it's added, return to Google Search Console
5. Click **"Verify"**

### Method 2: DNS Record (Alternative)
1. Google will provide a TXT record
2. Log in to your domain registrar (where you bought cottoncityplumbing.com)
3. Add the TXT record to your DNS settings
4. Wait 24-48 hours for DNS propagation
5. Return to Google Search Console and click **"Verify"**

---

## Step 4: Submit Your Sitemap

Once verified, submit your sitemap to help Google discover all your pages:

1. In Google Search Console, click **"Sitemaps"** in the left sidebar
2. Under "Add a new sitemap", enter: `sitemap.xml`
3. Click **"Submit"**

**Your sitemap URL is:** `https://www.cottoncityplumbing.com/sitemap.xml`

### What's in Your Sitemap?

Your sitemap automatically includes:
- **35+ static pages** (homepage, about, services, contact, etc.)
- **All 14 service pages** (water heaters, drain cleaning, emergency plumbing, etc.)
- **All 12 service area pages** (Lubbock, Wolfforth, Slaton, Shallowater, etc.)
- **26+ job pin detail pages** (dynamically updated as technicians add jobs)
- **6 blog posts** (tank vs tankless, emergency plumbing, frozen pipes, etc.)

The sitemap updates automatically when new job pins are added!

---

## Step 5: Monitor Indexing Progress

After submitting your sitemap:

1. Click **"Sitemaps"** in the left sidebar
2. You'll see your sitemap with status "Success" (may take a few hours)
3. Check the **"Discovered"** and **"Indexed"** columns to track progress

**Timeline:**
- **First 24 hours:** Google discovers 20-30% of pages
- **First week:** 60-80% of pages indexed
- **First month:** 90%+ of pages indexed

---

## Step 6: Check Coverage Report

Monitor which pages are indexed:

1. Click **"Coverage"** in the left sidebar (under "Index")
2. Look for:
   - **Valid pages:** Green checkmark (good!)
   - **Errors:** Red X (needs fixing)
   - **Warnings:** Yellow triangle (review)

Common issues and fixes:
- **"Submitted URL not found (404)"** → Check that the page exists
- **"Redirect error"** → Ensure URLs don't redirect unnecessarily
- **"Soft 404"** → Page appears empty to Google (add more content)

---

## Step 7: Enable Email Notifications

Get alerts for critical issues:

1. Click the **Settings** icon (gear) in the top-right
2. Click **"Users and permissions"**
3. Ensure your email is listed
4. Click **"Email notifications"** in settings
5. Enable notifications for:
   - Critical site errors
   - Manual actions
   - Security issues

---

## Expected Results

After setup, you should see:

### Week 1:
- Sitemap processed successfully
- 20-30 pages indexed
- Homepage appears in Google search for "Cotton City Plumbing Lubbock"

### Month 1:
- 80+ pages indexed
- Ranking for 15-20 local keywords
- Job pin pages appearing in search results

### Month 3:
- 100+ pages indexed (including all job pins)
- Ranking on page 1 for key services
- Rich snippets showing (star ratings, FAQs, business info)

---

## Advanced Features to Explore

Once your site is verified and indexed:

### 1. Performance Report
- See which keywords drive traffic
- Monitor click-through rates
- Identify ranking opportunities

### 2. URL Inspection Tool
- Check indexing status of specific pages
- Request immediate indexing for new pages
- See how Google renders your pages

### 3. Mobile Usability
- Ensure all pages work on mobile devices
- Fix mobile-specific errors

### 4. Core Web Vitals
- Monitor page speed and user experience
- Identify slow-loading pages

---

## Troubleshooting

### "Verification failed"
- **Solution:** Ensure the verification tag is in the `<head>` section of your homepage
- **Check:** Visit your homepage, right-click → "View Page Source", search for "google-site-verification"

### "Sitemap could not be read"
- **Solution:** Check that `https://www.cottoncityplumbing.com/sitemap.xml` loads correctly
- **Test:** Open the URL in your browser—you should see XML content

### "Sitemap is HTML"
- **Solution:** Ensure you're submitting `sitemap.xml`, not a regular page URL

### "No data yet"
- **Solution:** Wait 24-48 hours after submission for data to appear

---

## Next Steps After Setup

1. **Submit to Bing Webmaster Tools** (similar process, different search engine)
2. **Set up Google Analytics** for detailed traffic insights
3. **Monitor weekly** for indexing issues or ranking changes
4. **Request indexing** for new blog posts or service pages immediately after publishing

---

## Need Help?

If you encounter any issues during setup:
1. Send me the error message or screenshot
2. I can help troubleshoot or add verification codes
3. Google also provides live chat support in Search Console

---

## Summary Checklist

- [ ] Create Google Search Console account
- [ ] Add cottoncityplumbing.com as a property
- [ ] Verify ownership (HTML tag or DNS)
- [ ] Submit sitemap.xml
- [ ] Enable email notifications
- [ ] Monitor coverage report weekly
- [ ] Check performance data monthly

**Your sitemap is already live and ready to submit!** Just follow the verification steps above.
