# Google My Business Update Guide
## Cotton City Plumbing Website

This guide will walk you through updating your Google My Business (GMB) listing to point to your new Manus-powered website.

---

## Why Update Your GMB Listing?

Your Google My Business listing is one of the most important local SEO assets. When customers search "plumber near me" or "Cotton City Plumbing", your GMB listing appears with:
- Business hours
- Phone number
- **Website link** ← This is what we're updating
- Reviews
- Photos
- Map location

Updating the website URL ensures customers click through to your new, optimized website instead of the old Aligned by Design site.

---

## Step 1: Access Google My Business

1. Go to [https://business.google.com](https://business.google.com)
2. Sign in with the Google account that manages your business listing
   - **Not sure which account?** Try the email you use for business or ask your marketing agency
3. You should see "Cotton City Plumbing" in your business list

**Don't have access?**
- If Aligned by Design manages your GMB, you'll need to request access or transfer ownership
- See "Requesting Access from Your Agency" section below

---

## Step 2: Select Your Business

1. On the Google Business Profile dashboard, click **"Cotton City Plumbing"**
2. You'll see an overview of your business info, reviews, and insights

---

## Step 3: Update Website URL

### Option A: Via Google Business Profile Manager (Desktop)

1. In the left sidebar, click **"Info"**
2. Scroll down to find **"Website"**
3. Click the pencil icon (✏️) next to the current website URL
4. **Delete the old URL** (likely pointing to Aligned by Design site)
5. **Enter your new URL:** `https://www.cottoncityplumbing.com`
6. Click **"Apply"** or **"Save"**

### Option B: Via Google Maps (Mobile)

1. Open the **Google Maps** app on your phone
2. Search for "Cotton City Plumbing"
3. Tap **"Suggest an edit"**
4. Tap **"Website"**
5. Enter: `https://www.cottoncityplumbing.com`
6. Tap **"Submit"**

---

## Step 4: Verify the Change

After updating:

1. Wait **24-48 hours** for the change to propagate
2. Search "Cotton City Plumbing Lubbock" on Google
3. Look at your business listing on the right side (Knowledge Panel)
4. Click the **"Website"** button
5. Confirm it opens your new Manus website (not the old Aligned site)

**Important:** Google may take up to 3 days to review and approve the change.

---

## Step 5: Update Other GMB Information (Recommended)

While you're in the GMB dashboard, optimize these sections:

### Business Description
Click **"Info"** → **"Business description"**

**Suggested description:**
```
Cotton City Plumbing is Lubbock's trusted, faith-based plumbing company serving West Texas since [YEAR]. We specialize in water heater installation & repair, emergency plumbing, drain cleaning, leak detection, and commercial plumbing. Our licensed Master Plumber brings 30+ years of experience and uses advanced camera inspection technology. Same-day service available. Call (806) 441-4110 for honest, reliable plumbing service.
```

### Services
Click **"Info"** → **"Services"** → **"Add services"**

Add these services if not already listed:
- Emergency Plumbing
- Water Heater Installation
- Water Heater Repair
- Drain Cleaning
- Leak Detection
- Slab Leak Repair
- Gas Line Installation
- Water Treatment Systems
- Commercial Plumbing
- Whole House Repiping
- Sewer Repair
- Fixture Installation

### Business Hours
Click **"Info"** → **"Hours"**

Confirm your hours are accurate:
- **Monday - Friday:** 7:00 AM - 7:00 PM
- **Saturday:** 8:00 AM - 12:00 PM
- **Sunday:** Closed

### Photos
Click **"Photos"** → **"Add photos"**

Upload high-quality photos from your website:
- Team photos (from `/public/images/team-*.png`)
- Completed work (from `/public/images/work-*.png`)
- Trucks with Cotton City branding
- Before/after shots

**Tip:** Upload at least 10 photos. Listings with 10+ photos get 42% more direction requests!

### Attributes
Click **"Info"** → **"Attributes"**

Enable these if applicable:
- ✅ Locally owned and operated
- ✅ Family-owned
- ✅ Faith-based
- ✅ Licensed
- ✅ Insured
- ✅ Same-day service available
- ✅ Accepts credit cards
- ✅ Accepts cash
- ✅ Accepts checks

---

## Step 6: Optimize for Local SEO

### Add Posts (Free Advertising!)
Click **"Posts"** → **"Add update"**

Create weekly posts like:
- "New blog post: Tank vs Tankless Water Heaters for Lubbock Homes"
- "Winter is coming! Schedule your water heater maintenance today"
- "Check out our recent water heater installation in Tech Terrace"

**Include:**
- Eye-catching photo
- Brief description (150-300 words)
- Call-to-action button ("Call now" or "Learn more")
- Link to your website

### Respond to Reviews
Click **"Reviews"**

**Respond to every review** (good or bad):
- **5-star reviews:** Thank them by name, mention specific service
- **4-star reviews:** Thank them, ask how you could've earned 5 stars
- **1-3 star reviews:** Apologize, offer to make it right, provide contact info

**Example response:**
```
Thank you, Sarah! We're so glad we could help with your emergency plumbing issue. Our team takes pride in fast, professional service. If you ever need anything else, call us at (806) 441-4110. - Cotton City Plumbing Team
```

### Enable Messaging
Click **"Messages"**

Turn on messaging so customers can text you directly from your GMB listing. This increases engagement and leads!

---

## Requesting Access from Your Agency

If Aligned by Design currently manages your GMB listing:

### Step 1: Request Transfer
1. Email or call Aligned by Design
2. Request they transfer **ownership** (not just manager access) to your Google account
3. Provide your Google account email address

### Step 2: Accept Invitation
1. Check your email for an invitation from Google My Business
2. Click **"Accept invitation"**
3. Follow the prompts to gain access

### Step 3: Remove Agency Access (Optional)
Once you have owner access:
1. Go to **"Users"** in GMB dashboard
2. Find Aligned by Design's account
3. Click **"Remove"** to revoke their access

**Important:** If you're still under contract with Aligned by Design, consult your agreement before removing their access.

---

## Verifying Ownership (If Needed)

If Google asks you to verify ownership:

### Method 1: Postcard Verification
1. Google mails a postcard to your business address (5707 Ave. Q South Drive)
2. Wait 5-7 business days for delivery
3. Enter the 5-digit code from the postcard in GMB dashboard

### Method 2: Phone Verification
1. Google calls your business phone number
2. Answer and listen for the automated code
3. Enter the code in GMB dashboard

### Method 3: Email Verification
1. Google sends a code to your business email
2. Check your inbox for the code
3. Enter it in GMB dashboard

---

## Common Issues & Solutions

### "I don't have access to the Google account"
**Solution:** Request access from whoever set up the listing (likely Aligned by Design or a previous employee). If no one knows, you'll need to request ownership through Google's support.

### "The website URL keeps reverting to the old site"
**Solution:** 
1. Ensure you're editing the correct listing (not a duplicate)
2. Check if someone else has manager access and is changing it back
3. Contact Google My Business support for help

### "I see multiple Cotton City Plumbing listings"
**Solution:** 
1. Identify the correct listing (should have your reviews and correct address)
2. Mark duplicate listings as "Closed" or request removal
3. Consolidate all reviews/photos to the primary listing

### "Changes aren't showing up"
**Solution:** Wait 24-48 hours. Google reviews all edits before publishing them.

---

## Monitoring Your GMB Performance

After updating, track these metrics:

### Insights Dashboard
Click **"Insights"** to see:
- **Search queries:** What keywords customers use to find you
- **Views:** How many people see your listing
- **Actions:** Calls, website clicks, direction requests
- **Photo views:** Which photos get the most engagement

**Goal metrics:**
- **100+ views per week** (local searches)
- **20+ website clicks per week**
- **10+ phone calls per week**

### Review Monitoring
- **Current rating:** 4.9 stars ⭐
- **Goal:** Maintain 4.8+ stars with 50+ reviews
- **Strategy:** Ask every satisfied customer to leave a review

**How to ask for reviews:**
1. After completing a job, send a follow-up text/email
2. Include direct link to your GMB review page
3. Make it easy: "We'd love your feedback! Click here to leave a review: [LINK]"

**Your review link:**
`https://g.page/r/[YOUR_GMB_ID]/review`

(To find your exact link, go to GMB → "Home" → "Get more reviews" → Copy the short URL)

---

## Integration with Your Website

Your new website already includes:

✅ **Google Reviews widget** on homepage (displays your 4.9-star rating)  
✅ **Schema.org markup** (tells Google about your business)  
✅ **LocalBusiness structured data** (includes your GMB info)  
✅ **Click-to-call buttons** (tracks phone calls from website)  

These features work together with your GMB listing to maximize local SEO!

---

## Next Steps After Updating

1. **Week 1:** Monitor GMB insights to see traffic increase
2. **Week 2:** Respond to all reviews (show Google you're active)
3. **Week 3:** Add weekly posts with links to your website
4. **Week 4:** Upload 10+ new photos from recent jobs

**Monthly tasks:**
- Post 4 updates (1 per week)
- Respond to all new reviews within 24 hours
- Upload 5-10 new photos
- Check insights for trending keywords

---

## Summary Checklist

- [ ] Access Google My Business dashboard
- [ ] Update website URL to https://www.cottoncityplumbing.com
- [ ] Verify change appears in Google search (24-48 hours)
- [ ] Update business description
- [ ] Add all services
- [ ] Confirm business hours are accurate
- [ ] Upload 10+ high-quality photos
- [ ] Enable messaging
- [ ] Respond to all reviews
- [ ] Create first GMB post linking to website
- [ ] Monitor insights weekly

**Your new website is ready to receive GMB traffic!** Just update the URL and watch the leads roll in.

---

## Need Help?

If you need assistance:
1. **Google My Business support:** [https://support.google.com/business](https://support.google.com/business)
2. **Request ownership:** [https://support.google.com/business/answer/4566671](https://support.google.com/business/answer/4566671)
3. **Send me a screenshot** of any error messages and I can help troubleshoot
